/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.crystallizer;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CrystallizerFuelRecipe
implements IRecipeWrapper {
    @Nonnull
    private final List<List<ItemStack>> inputs;
    @Nonnull
    private final String smeltCountString;
    @Nonnull
    private final IDrawableAnimated flame;

    public CrystallizerFuelRecipe(@Nonnull IGuiHelper guiHelper, @Nonnull Collection<ItemStack> input, int burnTime) {
        Preconditions.checkArgument((burnTime > 0 ? 1 : 0) != 0, (Object)"burn time must be greater than 0");
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(input);
        this.inputs = Collections.singletonList(inputList);
        if (burnTime == 200) {
            this.smeltCountString = I18n.func_135052_a((String)"gui.jei.category.fuel.smeltCount.single", (Object[])new Object[0]);
        } else {
            NumberFormat numberInstance = NumberFormat.getNumberInstance();
            numberInstance.setMaximumFractionDigits(2);
            String smeltCount = numberInstance.format((float)burnTime / 200.0f);
            this.smeltCountString = I18n.func_135052_a((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
        }
        ResourceLocation furnaceBackgroundLocation = new ResourceLocation("abyssalcraft", "textures/gui/container/crystallizer_NEI.png");
        this.flame = guiHelper.drawableBuilder(furnaceBackgroundLocation, 176, 0, 14, 14).buildAnimated(burnTime, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 1, -2);
        minecraft.field_71466_p.func_78276_b(this.smeltCountString, 24, 13, Color.gray.getRGB());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
    }
}

