/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class NecromancyWorldSavedData
extends WorldSavedData {
    private static final String DATA_NAME = "abyssalcraft_necromancy_data";
    List<Tuple<String, NBTTagCompound>> data = new ArrayList<Tuple<String, NBTTagCompound>>();

    public NecromancyWorldSavedData() {
        super(DATA_NAME);
    }

    public NecromancyWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound properties = nbt;
        NBTTagCompound data = properties.func_74775_l("Data");
        if (properties.func_74764_b("Version")) {
            for (String name : data.func_150296_c()) {
                NBTTagList list = data.func_150295_c(name, 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.storeDataInternal(name, list.func_150305_b(i));
                }
            }
        } else {
            NBTTagCompound sizes = properties.func_74775_l("Sizes");
            for (String name : data.func_150296_c()) {
                this.storeDataLegacy(name, data.func_74775_l(name), sizes.func_74762_e(name));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("Version", 1);
        NBTTagCompound data = new NBTTagCompound();
        for (Tuple<String, NBTTagCompound> t : this.getData()) {
            if (data.func_74764_b((String)t.func_76341_a())) {
                data.func_150295_c((String)t.func_76341_a(), 10).func_74742_a((NBTBase)t.func_76340_b());
                continue;
            }
            NBTTagList list = new NBTTagList();
            list.func_74742_a((NBTBase)t.func_76340_b());
            data.func_74782_a((String)t.func_76341_a(), (NBTBase)list);
        }
        properties.func_74782_a("Data", (NBTBase)data);
        return properties;
    }

    public NBTTagCompound getDataForName(String name) {
        for (Tuple<String, NBTTagCompound> t : this.data) {
            if (!((String)t.func_76341_a()).equals(name)) continue;
            return (NBTTagCompound)t.func_76340_b();
        }
        return null;
    }

    public void storeData(String name, NBTTagCompound data, int size) {
        data.func_74768_a("ResurrectionRitualCrystalSize", size);
        this.storeDataInternal(name, data);
        this.func_76185_a();
    }

    private void storeDataInternal(String name, NBTTagCompound data) {
        if (this.data.size() == 5) {
            this.data.remove(0);
        }
        this.data.add((Tuple<String, NBTTagCompound>)new Tuple((Object)name, (Object)data));
    }

    private void storeDataLegacy(String name, NBTTagCompound data, int size) {
        data.func_74768_a("ResurrectionRitualCrystalSize", size);
        this.storeDataInternal(name, data);
    }

    public void clearEntry(String name) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!((String)this.data.get(i).func_76341_a()).equals(name)) continue;
            this.data.remove(i);
            break;
        }
        this.func_76185_a();
    }

    public List<Tuple<String, NBTTagCompound>> getData() {
        return this.data;
    }

    public static NecromancyWorldSavedData get(World world) {
        MapStorage storage = world.func_175693_T();
        NecromancyWorldSavedData instance = (NecromancyWorldSavedData)storage.func_75742_a(NecromancyWorldSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new NecromancyWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

