/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.common.world.gen.layer.GenLayerDL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeProviderDreadlands
extends BiomeProvider {
    private GenLayer biomeToUse;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);
    private List<Biome> biomesToSpawnIn = new ArrayList<Biome>();

    public BiomeProviderDreadlands() {
        this.biomesToSpawnIn.add(ACBiomes.dreadlands);
        this.biomesToSpawnIn.add(ACBiomes.purified_dreadlands);
        this.biomesToSpawnIn.add(ACBiomes.dreadlands_forest);
        this.biomesToSpawnIn.add(ACBiomes.dreadlands_mountains);
    }

    public BiomeProviderDreadlands(long par1, WorldType par3WorldType) {
        this();
        GenLayer[] agenlayer = GenLayerDL.makeTheWorld(par1);
        this.biomeToUse = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public BiomeProviderDreadlands(World par1world) {
        this(par1world.func_72905_C(), par1world.func_72912_H().func_76067_t());
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome biomegen) {
        Biome biome = this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), biomegen);
        if (biome == null) {
            return ACBiomes.dreadlands;
        }
        return biome;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public Biome[] func_76937_a(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
            par1ArrayOfBiome = new Biome[par4 * par5];
        }
        int[] aint = this.biomeToUse.func_75904_a(par2, par3, par4, par5);
        for (int i = 0; i < par4 * par5; ++i) {
            par1ArrayOfBiome[i] = aint[i] >= 0 && aint[i] <= Biome.field_185377_q.func_148742_b().size() ? Biome.func_150568_d((int)aint[i]) : ACBiomes.dreadlands;
        }
        return par1ArrayOfBiome;
    }

    public Biome[] func_76933_b(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiome, par2, par3, par4, par5, true);
    }

    public Biome[] func_76931_a(Biome[] par1ArrayOfBiome, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < width * length) {
            par1ArrayOfBiome = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            Biome[] aBiome1 = this.biomeCache.func_76839_e(x, y);
            System.arraycopy(aBiome1, 0, par1ArrayOfBiome, 0, width * length);
            return par1ArrayOfBiome;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiome[i] = aint[i] >= 0 && aint[i] <= Biome.field_185377_q.func_148742_b().size() ? Biome.func_150568_d((int)aint[i]) : ACBiomes.dreadlands;
        }
        return par1ArrayOfBiome;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        IntCache.func_76446_a();
        int l = par1 - par3 >> 2;
        int i1 = par2 - par3 >> 2;
        int j1 = par1 + par3 >> 2;
        int k1 = par2 + par3 >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.biomeToUse.func_75904_a(l, i1, l1, i2);
        for (int j2 = 0; j2 < l1 * i2; ++j2) {
            Biome biome = Biome.func_150568_d((int)aint[j2]);
            if (par4List.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        IntCache.func_76446_a();
        int l = par1 - par3 >> 2;
        int i1 = par2 - par3 >> 2;
        int j1 = par1 + par3 >> 2;
        int k1 = par2 + par3 >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.biomeToUse.func_75904_a(l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[k2]);
            if (!par4List.contains(biome) || blockpos != null && par5Random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

