/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.world;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.entity.EntityODBPrimed;
import com.shinoow.abyssalcraft.common.entity.EntityODBcPrimed;
import com.shinoow.abyssalcraft.lib.util.ScheduledProcess;
import com.shinoow.abyssalcraft.lib.util.Scheduler;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.ForgeEventFactory;

public class ACExplosion
extends Explosion {
    public boolean isAntimatter;
    public boolean isSmoking = true;
    private Random explosionRNG = new Random();
    private World worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity field_77283_e;
    public float explosionSize;
    public List<BlockPos> field_77281_g = new ArrayList<BlockPos>();
    private List<BlockPos> innerBlocks = new ArrayList<BlockPos>();
    private List<BlockPos> outerBlocks = new ArrayList<BlockPos>();
    private Map<EntityPlayer, Vec3d> playerKnockbackMap = new HashMap<EntityPlayer, Vec3d>();
    private Map<ChunkPos, Chunk> chunkCache = new HashMap<ChunkPos, Chunk>();
    private Set<Chunk> chunks = new THashSet();

    public ACExplosion(World world, Entity entity, double x, double y, double z, float strength, boolean antimatter, boolean smoke) {
        super(world, entity, x, y, z, strength, antimatter, smoke);
        this.worldObj = world;
        this.field_77283_e = entity;
        this.explosionSize = strength;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.isAntimatter = antimatter;
        this.isSmoking = smoke;
    }

    private void checkAndAdd(BlockPos pos, List<BlockPos> list) {
        if (!this.worldObj.func_189509_E(pos)) {
            float f2;
            Chunk c = this.getChunk(pos);
            IBlockState iblockstate = c.func_177435_g(pos);
            float f = f2 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.worldObj, pos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.worldObj, pos, (Entity)null, (Explosion)this);
            if (f2 < 600000.0f && iblockstate.func_185904_a() != Material.field_151579_a) {
                list.add(pos);
            }
        }
    }

    public void func_77278_a() {
        double radiusX = (double)this.explosionSize + 0.5;
        double radiusY = (double)this.explosionSize * 0.6 + 0.5;
        double radiusZ = (double)this.explosionSize + 0.5;
        BlockPos pos = new BlockPos(this.explosionX, this.explosionY, this.explosionZ);
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = xn * xn + yn * yn + zn * zn;
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (nextXn * nextXn + yn * yn + zn * zn <= 1.0 && xn * xn + nextYn * nextYn + zn * zn <= 1.0 && xn * xn + yn * yn + nextZn * nextZn <= 1.0) {
                        this.checkAndAdd(pos.func_177982_a(x, y, z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(-x, y, z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(x, -y, z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(x, y, -z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(-x, -y, z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(x, -y, -z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(-x, y, -z), this.innerBlocks);
                        this.checkAndAdd(pos.func_177982_a(-x, -y, -z), this.innerBlocks);
                        continue;
                    }
                    this.checkAndAdd(pos.func_177982_a(x, y, z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(-x, y, z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(x, -y, z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(x, y, -z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(-x, -y, z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(x, -y, -z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(-x, y, -z), this.outerBlocks);
                    this.checkAndAdd(pos.func_177982_a(-x, -y, -z), this.outerBlocks);
                }
            }
        }
        if (this.explosionSize <= 32.0f) {
            this.field_77281_g.addAll(this.innerBlocks);
            this.field_77281_g.addAll(this.outerBlocks);
        }
        if (!this.worldObj.field_72995_K) {
            float f3 = this.explosionSize * 2.0f;
            int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
            int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
            int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
            int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
            int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
            int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
            List list = this.worldObj.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            ForgeEventFactory.onExplosionDetonate((World)this.worldObj, (Explosion)this, (List)list, (double)f3);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                EntityPlayer entityplayer;
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                Entity entity = (Entity)list.get(k2);
                if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.explosionX) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * d7 + (d9 = entity.field_70161_v - this.explosionZ) * d9))) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d10 = 1.0 - d12;
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
                double d11 = 1.0;
                if (entity instanceof EntityLivingBase) {
                    d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
                }
                entity.field_70159_w += d5 * d11;
                entity.field_70181_x += d7 * d11;
                entity.field_70179_y += d9 * d11;
                if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
                this.playerKnockbackMap.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
            }
        }
    }

    private Chunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        this.chunkCache.putIfAbsent(cp, this.worldObj.func_72964_e(cp.field_77276_a, cp.field_77275_b));
        return this.chunkCache.get(cp);
    }

    public void func_77279_a(final boolean par1) {
        this.worldObj.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, new int[0]);
        }
        int num = 1;
        int index = 0;
        if (this.isSmoking) {
            List innerLists = Lists.partition(this.innerBlocks, (int)1000);
            for (Object innerList : innerLists) {
                Scheduler.schedule(new ScheduledProcess(num, (List)innerList){
                    final /* synthetic */ List val$innerList;
                    {
                        this.val$innerList = list;
                        super(time);
                    }

                    @Override
                    public void execute() {
                        for (BlockPos pos : this.val$innerList) {
                            Chunk chunk = ACExplosion.this.getChunk(pos);
                            ExtendedBlockStorage storage = chunk.func_76587_i()[pos.func_177956_o() >> 4];
                            if (storage != null) {
                                storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, Blocks.field_150350_a.func_176223_P());
                            }
                            ACExplosion.this.chunks.add(chunk);
                        }
                    }
                });
                if (++index % 1000 != 0) continue;
                ++num;
            }
            List outerLists = Lists.partition(this.outerBlocks, (int)100);
            for (final List outerList : outerLists) {
                final ACExplosion explosion = this;
                Scheduler.schedule(new ScheduledProcess(num){

                    @Override
                    public void execute() {
                        for (BlockPos pos : outerList) {
                            if (par1) {
                                ACExplosion.this.worldObj.func_180495_p(pos).func_177230_c().onBlockExploded(ACExplosion.this.worldObj, pos, (Explosion)explosion);
                                continue;
                            }
                            Chunk chunk = ACExplosion.this.getChunk(pos);
                            ExtendedBlockStorage storage = chunk.func_76587_i()[pos.func_177956_o() >> 4];
                            if (storage != null) {
                                storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, Blocks.field_150350_a.func_176223_P());
                            }
                            ACExplosion.this.chunks.add(chunk);
                        }
                    }
                });
                if (++index % 100 != 0) continue;
                ++num;
            }
        }
        if (this.isAntimatter) {
            List extraLists = Lists.partition(this.explosionSize <= 32.0f ? this.field_77281_g : this.outerBlocks, (int)100);
            for (final List extraList : extraLists) {
                Scheduler.schedule(new ScheduledProcess(num){

                    @Override
                    public void execute() {
                        for (BlockPos pos1 : extraList) {
                            IBlockState block = ACExplosion.this.worldObj.func_180495_p(pos1);
                            IBlockState block1 = ACExplosion.this.worldObj.func_180495_p(pos1.func_177977_b());
                            if (block.func_185904_a() != Material.field_151579_a || !block1.func_185913_b() || ACExplosion.this.explosionRNG.nextInt(3) != 0) continue;
                            ACExplosion.this.worldObj.func_175656_a(pos1, ACBlocks.liquid_antimatter.func_176223_P());
                        }
                    }
                });
                if (++index % 100 != 0) continue;
                ++num;
            }
        }
        Scheduler.schedule(new ScheduledProcess(num + 1){

            @Override
            public void execute() {
                PlayerChunkMap pcm = ((WorldServer)ACExplosion.this.worldObj).func_184164_w();
                if (pcm != null) {
                    for (Chunk c : ACExplosion.this.chunks) {
                        c.func_177427_f(true);
                        c.func_76603_b();
                        PlayerChunkMapEntry w = pcm.func_187301_b(c.field_76635_g, c.field_76647_h);
                        if (w == null) continue;
                        w.func_187267_a((Packet)new SPacketChunkData(c, 65535));
                    }
                }
            }
        });
        if (this.field_77283_e instanceof EntityODBPrimed) {
            ((EntityODBPrimed)this.field_77283_e).finishExplosion(num + 10, this);
        }
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public List<BlockPos> func_180343_e() {
        return this.explosionSize <= 32.0f ? this.field_77281_g : this.innerBlocks;
    }

    public EntityLivingBase func_94613_c() {
        return this.field_77283_e == null ? null : (this.field_77283_e instanceof EntityODBPrimed ? ((EntityODBPrimed)this.field_77283_e).getODBPlacedBy() : (this.field_77283_e instanceof EntityODBcPrimed ? ((EntityODBcPrimed)this.field_77283_e).getODBCPlacedBy() : (this.field_77283_e instanceof EntityLivingBase ? (EntityLivingBase)this.field_77283_e : null)));
    }
}

