/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import com.shinoow.abyssalcraft.init.InitHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class InterdimensionalCageMessage
extends AbstractMessage.AbstractServerMessage<InterdimensionalCageMessage> {
    int id;
    EnumHand hand;

    public InterdimensionalCageMessage() {
    }

    public InterdimensionalCageMessage(int id, EnumHand hand) {
        this.id = id;
        this.hand = hand;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.id = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)4);
        this.hand = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)4) == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.id, (int)4);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)(this.hand == EnumHand.MAIN_HAND ? 0 : 1), (int)4);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        EntityLivingBase target;
        if (player.func_184586_b(this.hand) == null) {
            return;
        }
        ItemStack stack = player.func_184586_b(this.hand);
        Entity e = player.field_70170_p.func_73045_a(this.id);
        if (e == null) {
            return;
        }
        if (InitHandler.INSTANCE.isEntityBlacklisted(e)) {
            return;
        }
        if (stack.func_77973_b() == ACItems.interdimensional_cage && stack.func_77973_b() instanceof IEnergyContainerItem && e instanceof EntityLivingBase && (target = (EntityLivingBase)e).func_184222_aU() && target.func_184188_bt().isEmpty() && target.func_184187_bx() == null && !target.field_70128_L && ((IEnergyContainerItem)stack.func_77973_b()).getContainedEnergy(stack) >= this.getPEFromSize(target.field_70130_N, target.field_70131_O)) {
            NBTTagCompound tag = target.serializeNBT();
            stack.func_77978_p().func_74782_a("Entity", (NBTBase)tag);
            stack.func_77978_p().func_74778_a("EntityName", target.func_70005_c_());
            ((IEnergyContainerItem)stack.func_77973_b()).consumeEnergy(stack, this.getPEFromSize(target.field_70130_N, target.field_70131_O));
            player.field_70170_p.func_72900_e((Entity)target);
        }
    }

    private float getPEFromSize(float width, float height) {
        return height * width * width * 100.0f;
    }
}

