/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.items;

import com.shinoow.abyssalcraft.api.transfer.ItemTransferConfiguration;
import com.shinoow.abyssalcraft.api.transfer.caps.IItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapability;
import com.shinoow.abyssalcraft.client.ClientProxy;
import com.shinoow.abyssalcraft.common.handlers.ItemTransferEventHandler;
import com.shinoow.abyssalcraft.common.items.ItemACBasic;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.util.ParticleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConfigurator
extends ItemACBasic {
    public ItemConfigurator() {
        super("configurator");
        this.func_77637_a(ACTabs.tabTools);
        this.func_185043_a(new ResourceLocation("mode"), (stack, worldIn, entityIn) -> stack.func_77942_o() ? this.intToFloat(stack.func_77978_p().func_74762_e("Mode")) : 0.0f);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (isSelected && worldIn.field_72995_K) {
            int mode;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((mode = stack.func_77978_p().func_74762_e("Mode")) == 0) {
                NBTTagList path = stack.func_77978_p().func_150295_c("Path", 4);
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                Iterator i = path.iterator();
                while (i.hasNext()) {
                    positions.add(BlockPos.func_177969_a((long)((NBTTagLong)i.next()).func_150291_c()));
                }
                BlockPos prevPos = null;
                for (int i2 = 0; i2 < positions.size(); ++i2) {
                    boolean last;
                    BlockPos pos = (BlockPos)positions.get(i2);
                    boolean bl = last = i2 == positions.size() - 1;
                    if (last) {
                        worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (prevPos == null) {
                        prevPos = pos;
                    } else {
                        ParticleUtil.spawnParticleLine(prevPos, pos, 4, (v1, v2) -> {
                            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                            return false;
                        });
                    }
                    prevPos = pos;
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!w.field_72995_K) {
            NBTTagCompound nbt;
            int mode;
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((mode = (nbt = stack.func_77978_p()).func_74762_e("Mode")) == 0) {
                NBTTagList path = null;
                path = nbt.func_74764_b("Path") ? nbt.func_150295_c("Path", 4) : new NBTTagList();
                TileEntity te = w.func_175625_s(pos);
                if (te != null && ItemTransferEventHandler.hasInventory(te)) {
                    path.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
                    nbt.func_74768_a("EntryFacing", side.func_176745_a());
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.1", new Object[0]));
                } else {
                    path.func_74742_a((NBTBase)new NBTTagLong(pos.func_177984_a().func_177986_g()));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.2", new Object[0]));
                }
                nbt.func_74782_a("Path", (NBTBase)path);
            } else if (mode == 1) {
                if (player.func_175151_a(pos.func_177972_a(side), side, stack)) {
                    TileEntity te = w.func_175625_s(pos);
                    if (te != null && ItemTransferCapability.getCap(te) != null) {
                        IItemTransferCapability cap = ItemTransferCapability.getCap(te);
                        NonNullList filter = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)filter);
                        NBTTagList path = nbt.func_150295_c("Path", 4);
                        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                        Iterator i = path.iterator();
                        while (i.hasNext()) {
                            positions.add(BlockPos.func_177969_a((long)((NBTTagLong)i.next()).func_150291_c()));
                        }
                        if (positions.isEmpty()) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.1", new Object[0]));
                            return EnumActionResult.FAIL;
                        }
                        EnumFacing facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("EntryFacing"));
                        TileEntity res = w.func_175625_s((BlockPos)positions.get(positions.size() - 1));
                        if (res == null || ItemTransferEventHandler.getInventory(res, facing) == null) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.2", new Object[0]));
                            return EnumActionResult.FAIL;
                        }
                        ItemTransferConfiguration cfg = new ItemTransferConfiguration(positions.toArray(new BlockPos[0])).setExitFacing(side).setEntryFacing(facing).setFilter((NonNullList<ItemStack>)filter).setFilterSubtypes(nbt.func_74767_n("FilterSubtype")).setFilterNBT(nbt.func_74767_n("FilterNBT"));
                        cfg.setupSubtypeFilter();
                        cap.addTransferConfiguration(cfg);
                        cap.setRunning(true);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.3", new Object[0]));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.3", new Object[0]));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.4", new Object[0]));
                }
            } else if (mode == 2) {
                if (player.func_175151_a(pos.func_177972_a(side), side, stack)) {
                    TileEntity te = w.func_175625_s(pos);
                    if (te != null && ItemTransferCapability.getCap(te) != null) {
                        IItemTransferCapability cap = ItemTransferCapability.getCap(te);
                        cap.clearConfigurations();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.4", new Object[0]));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.3", new Object[0]));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.configurator.error.4", new Object[0]));
                }
            }
            return EnumActionResult.PASS;
        }
        return super.func_180614_a(player, w, pos, hand, side, hitX, hitY, hitZ);
    }

    private float intToFloat(int i) {
        switch (i) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getMode(int mode) {
        if (mode >= 0 && mode <= 2) {
            return I18n.func_135052_a((String)("tooltip.configurator.mode." + mode), (Object[])new Object[0]);
        }
        return ItemConfigurator.getMode(0);
    }

    public void func_77624_a(ItemStack is, World player, List<String> l, ITooltipFlag B) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        int mode = is.func_77978_p().func_74762_e("Mode");
        l.add(String.format("%s: %s", I18n.func_135052_a((String)"tooltip.staff.mode.1", (Object[])new Object[0]), TextFormatting.GOLD + ItemConfigurator.getMode(mode) + TextFormatting.GRAY));
        l.add(I18n.func_135052_a((String)"tooltip.staff.mode.2", (Object[])new Object[]{TextFormatting.GOLD + ClientProxy.configurator_mode.getDisplayName() + TextFormatting.GRAY}));
        l.add(I18n.func_135052_a((String)"tooltip.configurator.1", (Object[])new Object[]{TextFormatting.GOLD + ClientProxy.configurator_filter.getDisplayName() + TextFormatting.GRAY}));
        l.add(I18n.func_135052_a((String)"tooltip.configurator.2", (Object[])new Object[]{TextFormatting.GOLD + ClientProxy.configurator_path.getDisplayName() + TextFormatting.GRAY}));
    }
}

