/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.lib.util.ParticleUtil;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualAltar;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualPedestal;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileEntityRitualPedestal
extends TileEntity
implements ITickable,
IRitualPedestal {
    private ItemStack item = ItemStack.field_190927_a;
    private int itemID;
    private int itemMeta;
    private boolean isDirty;
    private BlockPos altarPos;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagCompound nbtItem = nbttagcompound.func_74775_l("Item");
        this.item = new ItemStack(nbtItem);
        if (nbttagcompound.func_74764_b("AltarPos")) {
            this.altarPos = BlockPos.func_177969_a((long)nbttagcompound.func_74763_f("AltarPos"));
        }
        this.itemID = nbttagcompound.func_74762_e("ItemID");
        this.itemMeta = nbttagcompound.func_74762_e("ItemMeta");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.item.func_190926_b()) {
            this.item.func_77955_b(nbtItem);
        }
        nbttagcompound.func_74782_a("Item", (NBTBase)nbtItem);
        if (this.altarPos != null) {
            nbttagcompound.func_74772_a("AltarPos", this.altarPos.func_177986_g());
        }
        nbttagcompound.func_74768_a("ItemID", this.itemID);
        nbttagcompound.func_74768_a("ItemMeta", this.itemMeta);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void onLoad() {
        IRitualAltar altar = this.getAltar();
        if (altar != null) {
            altar.addPedestal(this);
        }
    }

    public void func_73660_a() {
        IRitualAltar altar;
        if (this.isDirty) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.isDirty = false;
        }
        if ((altar = this.getAltar()) != null && altar.isPerformingRitual() && this.itemID != 0) {
            double velX;
            double xOffset = this.field_174879_c.func_177958_n() - this.altarPos.func_177958_n();
            double zOffset = this.field_174879_c.func_177952_p() - this.altarPos.func_177952_p();
            double d = xOffset == 0.0 ? 0.0 : (velX = xOffset < 0.0 ? 0.5 : -0.5);
            double velZ = zOffset == 0.0 ? 0.0 : (zOffset < 0.0 ? 0.5 : -0.5);
            this.spawnParticles(0.5, 0.5, velX, velZ, new int[]{this.itemID, this.itemMeta}, altar);
        }
    }

    private void spawnParticles(double xOffset, double zOffset, double velX, double velZ, int[] data, IRitualAltar altar) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        switch (altar.getRitualParticle()) {
            case GLYPHS: {
                int x = velX != 0.0 && velZ != 0.0 ? 4 : 6;
                int z = velZ != 0.0 && velX != 0.0 ? 4 : 6;
                this.field_145850_b.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)this.altarPos.func_177958_n() + xOffset, (double)this.altarPos.func_177956_o() + 2.05, (double)this.altarPos.func_177952_p() + zOffset, velX * (double)x, 0.15, velZ * (double)z, new int[0]);
                this.field_145850_b.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 2.05, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.15, 0.0, new int[0]);
                break;
            }
            case ITEM: {
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 0.95, (double)this.field_174879_c.func_177952_p() + zOffset, velX, 0.15, velZ, data);
                break;
            }
            case ITEM_SMOKE_COMBO: {
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 0.95, (double)this.field_174879_c.func_177952_p() + zOffset, velX, 0.15, velZ, data);
                    break;
                }
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, velX / 2.0, 0.0, velZ / 2.0, new int[0]);
                break;
            }
            case NONE: {
                break;
            }
            case SMOKE: {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, velX / 2.0, 0.0, velZ / 2.0, new int[0]);
                break;
            }
            case SMOKE_PILLARS: {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + xOffset, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + zOffset, 0.0, 0.15, 0.0, new int[0]);
                break;
            }
            case SPRINKLER: {
                double v12;
                int t;
                for (t = altar.getRitualCooldown(); t > 17; t -= 17) {
                }
                double v1 = 0.0;
                double v2 = 0.0;
                if (t % 2 == 0) {
                    v1 = 0.0;
                    v2 = 0.5;
                }
                if (t % 4 == 0) {
                    v1 = 0.5;
                    v2 = 0.5;
                }
                if (t % 6 == 0) {
                    v1 = 0.5;
                    v2 = 0.0;
                }
                if (t % 8 == 0) {
                    v1 = 0.5;
                    v2 = -0.5;
                }
                if (t % 10 == 0) {
                    v1 = 0.0;
                    v2 = -0.5;
                }
                if (t % 12 == 0) {
                    v1 = -0.5;
                    v2 = -0.5;
                }
                if (t % 14 == 0) {
                    v1 = -0.5;
                    v2 = 0.0;
                }
                if (t % 16 == 0) {
                    v1 = -0.5;
                    v2 = 0.5;
                }
                double d = v1 > 0.0 ? -0.1 : (v12 = v1 < 0.0 ? 0.1 : 0.0);
                double v22 = v2 > 0.0 ? -0.1 : (v2 < 0.0 ? 0.1 : 0.0);
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, v1, 0.15, v2, data);
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, v1 + v12, 0.15, v2 + v22, data);
                this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, v1 + v12 * 2.0, 0.15, v2 + v22 * 2.0, data);
                break;
            }
            case PE_STREAM: {
                if (altar.getRitualCooldown() % 20 != 0) break;
                int j = 1 + Minecraft.func_71410_x().field_71474_y.field_74362_aa;
                ParticleUtil.spawnParticleLine(this.field_174879_c, this.altarPos, 15, j, (vec1, vec2) -> {
                    if (AbyssalCraft.proxy.getParticleCount() < 10000) {
                        AbyssalCraft.proxy.spawnParticle("PEStream", vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, vec1.field_72450_a * 0.1, 0.15, vec1.field_72449_c * 0.1);
                    }
                    return false;
                });
                break;
            }
        }
        this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, 0.0, 0.0, 0.0, new int[0]);
        this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + xOffset, (double)this.field_174879_c.func_177956_o() + 1.05, (double)this.field_174879_c.func_177952_p() + zOffset, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = item;
        this.isDirty = true;
    }

    private ItemStack getStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b().hasContainerItem(stack)) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IRitualAltar getAltar() {
        return this.altarPos != null && this.field_145850_b.func_175625_s(this.altarPos) instanceof IRitualAltar ? (IRitualAltar)this.field_145850_b.func_175625_s(this.altarPos) : null;
    }

    @Override
    public void setAltar(BlockPos pos) {
        this.altarPos = pos;
        this.getAltar().addPedestal(this);
    }

    @Override
    public void consumeItem() {
        if (!this.item.func_190926_b()) {
            this.itemID = Item.func_150891_b((Item)this.item.func_77973_b());
            this.itemMeta = this.item.func_77960_j();
            this.setItem(this.getStack(this.item));
        } else {
            this.itemMeta = 0;
            this.itemID = 0;
            this.isDirty = true;
        }
    }
}

