/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.energy.disruption;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionEntry;
import com.shinoow.abyssalcraft.api.event.ACEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisruptionHandler {
    private final List<DisruptionEntry> disruptions = new ArrayList<DisruptionEntry>();
    private final Logger logger = LogManager.getLogger((String)"DisruptionHandler");
    private static final DisruptionHandler instance = new DisruptionHandler();

    public static DisruptionHandler instance() {
        return instance;
    }

    private DisruptionHandler() {
    }

    public void registerDisruption(DisruptionEntry disruption) {
        for (DisruptionEntry entry : this.disruptions) {
            if (!disruption.getUnlocalizedName().equals(entry.getUnlocalizedName())) continue;
            this.logger.log(Level.ERROR, "Disruption Entry already registered: {}", (Object)disruption.getUnlocalizedName());
            return;
        }
        this.disruptions.add(disruption);
    }

    public List<DisruptionEntry> getDisruptions() {
        return this.disruptions;
    }

    public DisruptionEntry disruptionFromName(String name) {
        if (name.startsWith("ac.disruption.")) {
            name.substring("ac.disruption.".length());
        }
        for (DisruptionEntry dis : this.disruptions) {
            if (!dis.getUnlocalizedName().substring("ac.disruption.".length()).equals(name)) continue;
            return dis;
        }
        return null;
    }

    public void generateDisruption(EnergyEnum.DeityType deity, World world, BlockPos pos, List<EntityPlayer> players) {
        DisruptionEntry disruption = this.getRandomDisruption(deity, world);
        if (disruption != null) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new ACEvents.DisruptionEvent(deity, world, pos, players, disruption))) {
                disruption.disrupt(world, pos, players);
            }
            AbyssalCraftAPI.getInternalMethodHandler().sendDisruption(deity, disruption.getUnlocalizedName().substring("ac.disruption.".length()), pos, world.field_73011_w.getDimension());
        }
    }

    public DisruptionEntry getRandomDisruption(EnergyEnum.DeityType deity, World world) {
        if (world.field_72995_K) {
            return null;
        }
        ArrayList<DisruptionEntry> dis = new ArrayList<DisruptionEntry>();
        if (deity == null) {
            for (DisruptionEntry entry : this.disruptions) {
                if (entry.getDeity() != null) continue;
                dis.add(entry);
            }
        } else {
            for (DisruptionEntry entry : this.disruptions) {
                if (entry.getDeity() != deity && entry.getDeity() != null) continue;
                dis.add(entry);
            }
        }
        return (DisruptionEntry)dis.get(world.field_73012_v.nextInt(dis.size()));
    }
}

