/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.filter;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.integration.jei.IHaveGhostTargets;
import crazypants.enderio.util.NbtValue;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import gg.galaxygaming.gasconduits.common.utils.GasUtil;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GasFilter
implements IGasFilter {
    private final GasStack[] gases = new GasStack[5];
    private boolean isBlacklist;

    @Override
    public boolean isEmpty() {
        return Arrays.stream(this.gases).noneMatch(Objects::nonNull);
    }

    @Override
    public int size() {
        return this.gases.length;
    }

    @Override
    public GasStack getGasStackAt(int index) {
        return index < 0 || index >= this.gases.length ? null : this.gases[index];
    }

    @Override
    public boolean setGas(int index, @Nullable GasStack gas) {
        if (index < 0 || index >= this.gases.length) {
            return false;
        }
        this.gases[index] = gas == null || gas.getGas() == null ? null : gas;
        return true;
    }

    @Override
    public boolean setGas(int index, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return this.setGas(index, (GasStack)null);
        }
        if (index < 0 || index >= this.gases.length) {
            return false;
        }
        GasStack f = GasUtil.getGasTypeFromItem(stack);
        if (f == null || f.getGas() == null) {
            return this.setGas(index, (GasStack)null);
        }
        return this.setGas(index, f);
    }

    @Override
    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    @Override
    public void setBlacklist(boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    @Override
    public boolean isDefault() {
        return !this.isBlacklist && this.isEmpty();
    }

    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NbtValue.FILTER_BLACKLIST.setBoolean(nbtRoot, this.isBlacklist);
        NBTTagList gasList = new NBTTagList();
        int index = 0;
        for (GasStack g : this.gases) {
            NBTTagCompound fRoot = new NBTTagCompound();
            if (g != null) {
                fRoot.func_74768_a("index", index);
                g.write(fRoot);
                gasList.func_74742_a((NBTBase)fRoot);
            }
            ++index;
        }
        nbtRoot.func_74782_a("gases", (NBTBase)gasList);
    }

    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.isBlacklist = NbtValue.FILTER_BLACKLIST.getBoolean(nbtRoot);
        this.clear();
        NBTTagList tagList = nbtRoot.func_74764_b("gasses") ? nbtRoot.func_150295_c("gasses", (int)nbtRoot.func_74732_a()) : nbtRoot.func_150295_c("gases", (int)nbtRoot.func_74732_a());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            this.gases[i] = GasStack.readFromNBT((NBTTagCompound)tagList.func_150305_b(i));
        }
    }

    private void clear() {
        Arrays.fill(this.gases, null);
    }

    @Override
    public boolean matchesFilter(GasStack drained) {
        if (drained == null || drained.getGas() == null) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (GasStack f : this.gases) {
            if (f == null || !f.isGasEqual(drained)) continue;
            return !this.isBlacklist;
        }
        return this.isBlacklist;
    }

    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        this.setGas(slot, stack);
    }

    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }

    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int index = 0;
        int numRows = 1;
        int rowSpacing = 2;
        int numCols = 5;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < numCols; ++col) {
                int x = xOffset + col * 18;
                int y = yOffset + row * 18 + rowSpacing * row;
                slots.add((Object)new GasFilterGhostSlot(index, x, y, cb));
                ++index;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return this.gases.length;
    }

    class GasFilterGhostSlot
    extends GhostSlot
    implements IHaveGhostTargets.ICustomGhostSlot {
        private final Runnable cb;

        GasFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
        }

        public void putStack(@Nonnull ItemStack stack, int realSize) {
            GasFilter.this.setGas(this.getSlot(), stack);
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return ItemStack.field_190927_a;
        }

        public void putIngredient(Object ingredient) {
            GasStack stack = null;
            if (ingredient instanceof Gas) {
                stack = new GasStack((Gas)ingredient, 0);
            } else if (ingredient instanceof GasStack) {
                stack = (GasStack)ingredient;
            }
            GasFilter.this.setGas(this.getSlot(), stack);
            this.cb.run();
        }

        public boolean isType(Object ingredient) {
            return ingredient instanceof GasStack || ingredient instanceof Gas;
        }
    }
}

