/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zeitheron.hammercore.net.HCNet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.net.packets.RequestPropertiesPacket;
import org.zeith.hammerlib.net.packets.SendPropertiesPacket;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.util.mcf.ByteBufTransposer;

public class PropertyDispatcher {
    public final BiMap<String, IProperty<?>> properties = HashBiMap.create();
    public final BiMap<IProperty<?>, String> propertiesInverse = this.properties.inverse();
    public final Map<String, IProperty<?>> dirty = new HashMap();
    public final Supplier<? extends IObjectSource<?>> source;
    public final Runnable onDirty;
    protected boolean clientSideSynced = false;

    public PropertyDispatcher(Supplier<? extends IObjectSource<?>> source, Runnable onDirty) {
        this.source = source;
        this.onDirty = onDirty;
    }

    public void tick(World level) {
        if (level.field_72995_K && !this.clientSideSynced) {
            this.clientSideSynced = true;
            this.requestProperties();
        }
    }

    public <T> IProperty<T> registerProperty(String id, IProperty<T> property) {
        if (id.startsWith("!")) {
            id = "." + id.substring(1);
        }
        this.properties.put((Object)id, property);
        property.setDispatcher(this);
        return property;
    }

    public IProperty<?> getProperty(String id) {
        if (id.startsWith("!")) {
            id = "." + id.substring(1);
        }
        return (IProperty)this.properties.get((Object)id);
    }

    public void decodeChanges(PacketBuffer buf) throws IOException {
        String str;
        while ("!".compareTo(str = buf.func_150789_c(Short.MAX_VALUE)) != 0) {
            IProperty prop = (IProperty)this.properties.get((Object)str);
            if (prop == null) continue;
            prop.read(buf);
        }
    }

    public void notifyOfChange(IProperty<?> prop) {
        String id = (String)this.propertiesInverse.get(prop);
        if (prop.hasChanged()) {
            this.dirty.put(id, prop);
            if (this.onDirty != null) {
                this.onDirty.run();
            }
        }
    }

    public void requestProperties() {
        HCNet.INSTANCE.sendToServer(new RequestPropertiesPacket(this.source.get()));
    }

    @Nullable
    public SendPropertiesPacket detectAndGenerateChanges(boolean cleanse) {
        ByteBufTransposer.Builder transposer = ByteBufTransposer.begin();
        PacketBuffer buf = transposer.buffer();
        if (!this.dirty.isEmpty()) {
            this.dirty.forEach((id, prop) -> {
                if (prop.hasChanged()) {
                    buf.func_180714_a(id);
                    prop.write(buf);
                    if (cleanse) {
                        prop.markChanged(false);
                    }
                }
            });
            if (cleanse) {
                this.dirty.clear();
            }
        }
        buf.func_180714_a("!");
        byte[] data = transposer.transpose();
        if (data.length > 0) {
            return new SendPropertiesPacket(this.source.get(), data);
        }
        return null;
    }

    @Nullable
    public SendPropertiesPacket createGlobalUpdate() {
        if (this.properties.isEmpty()) {
            return null;
        }
        ByteBufTransposer.Builder transposer = ByteBufTransposer.begin();
        PacketBuffer buf = transposer.buffer();
        this.properties.forEach((id, prop) -> {
            buf.func_180714_a(id);
            prop.write(buf);
        });
        buf.func_180714_a("!");
        return new SendPropertiesPacket(this.source.get(), transposer.transpose());
    }
}

