/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java.itf;

import java.util.function.Predicate;

public interface ToFloatFunction<T> {
    public float applyAsFloat(T var1);

    default public ToFloatFunction<T> plus(float amount) {
        return t -> amount + this.applyAsFloat(t);
    }

    default public ToFloatFunction<T> plus(ToFloatFunction<T> other) {
        ToFloatFunction th = this;
        return t -> th.applyAsFloat(t) + other.applyAsFloat(t);
    }

    default public ToFloatFunction<T> plus(ToFloatFunction<T> other, ToFloatFunction<T> ... fun) {
        return t -> {
            float b = this.applyAsFloat(t) + other.applyAsFloat(t);
            for (ToFloatFunction fn : fun) {
                b += fn.applyAsFloat(t);
            }
            return b;
        };
    }

    default public ToFloatFunction<T> onlyIf(Predicate<T> filter) {
        return f -> filter.test(f) ? this.applyAsFloat(f) : 0.0f;
    }

    public static <T> ToFloatFunction<T> sum(float base, ToFloatFunction<T> ... all) {
        return t -> {
            float sum = base;
            for (ToFloatFunction f : all) {
                sum += f.applyAsFloat(t);
            }
            return sum;
        };
    }

    public static <T> ToFloatFunction<T> constant(float f) {
        return t -> f;
    }
}

