/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.java;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class DirectStorage<T> {
    final Consumer<T> set;
    final Supplier<T> get;

    public DirectStorage(Consumer<T> set, Supplier<T> get) {
        this.set = set;
        this.get = get;
    }

    public void set(T val) {
        if (this.set != null) {
            this.set.accept(val);
        }
    }

    public T get() {
        return this.get.get();
    }

    public T apply(UnaryOperator<T> operator) {
        Object v = operator.apply(this.get());
        this.set(v);
        return (T)v;
    }

    public static <T> DirectStorage<T> create(Consumer<T> set, Supplier<T> get) {
        return new DirectStorage<T>(set, get);
    }

    public static <T> DirectStorage<T> readonly(Supplier<T> get) {
        return new DirectStorage<T>(null, get);
    }

    public static <T> DirectStorage<T> constant(T var) {
        return new DirectStorage<Object>(null, () -> var);
    }

    public static <T> DirectStorage<T> allocate() {
        AtomicReference ref = new AtomicReference();
        return DirectStorage.create(ref::set, ref::get);
    }

    public static <T> DirectStorage<T> allocate(T intitial) {
        AtomicReference<T> ref = new AtomicReference<T>(intitial);
        return DirectStorage.create(ref::set, ref::get);
    }

    public String toString() {
        return "DirectStorage{" + this.get() + "}";
    }
}

