/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.transport.impl;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.net.transport.ITransportAcceptor;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PacketWrapperAcceptor
implements ITransportAcceptor {
    byte[] data;
    IPacket decoded;

    @Override
    public void read(InputStream readable, int length) {
        try (DataInputStream in = new DataInputStream(readable);){
            this.data = new byte[length];
            in.readFully(this.data);
            this.decoded = HCNet.readPacket(new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.data)));
            if (this.decoded != null) {
                this.data = null;
            }
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Override
    public void onTransmissionComplete(Side side, PacketContext ctx) {
        if (this.decoded == null) {
            HammerCore.LOG.error("Received bad packet on packet transport (WHAT IS THIS?!): {}", (Object)new String(this.data));
        } else {
            switch (side) {
                case CLIENT: {
                    this.decoded.executeOnClient2(ctx);
                    break;
                }
                case SERVER: {
                    this.decoded.executeOnServer2(ctx);
                    break;
                }
                default: {
                    HammerCore.LOG.error("WTF is this side " + side + " ?!");
                }
            }
        }
    }

    @Override
    public boolean executeOnMainThread() {
        return ITransportAcceptor.super.executeOnMainThread() || this.decoded != null && this.decoded.executeOnMainThread();
    }
}

