/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.props;

import com.zeitheron.hammercore.net.props.IPropertyChangeHandler;
import net.minecraft.nbt.NBTTagCompound;

public abstract class NetPropertyAbstract<T> {
    protected final IPropertyChangeHandler handler;
    protected final int id;
    protected T value;
    public boolean syncOnChange = true;

    public NetPropertyAbstract(IPropertyChangeHandler handler) {
        this.handler = handler;
        this.id = handler.registerProperty(this);
    }

    public NetPropertyAbstract(IPropertyChangeHandler handler, T initialValue) {
        this.handler = handler;
        this.id = handler.registerProperty(this);
        this.value = initialValue;
    }

    public int getId() {
        return this.id;
    }

    public abstract NBTTagCompound writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public T get() {
        return this.value;
    }

    public void set(T val) {
        if (!NetPropertyAbstract.equals(val, this.value)) {
            this.value = val;
            this.handler.notifyOfChange(this);
            if (this.syncOnChange) {
                this.handler.sendChangesToNearby();
            }
        }
    }

    private static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b) && b.equals(a);
    }
}

