/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.ap;

import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public interface IAPContext {
    public static final IAPContext DUMMY = new IAPContext(){};

    default public Optional<ResourceLocation> getRegistryName() {
        return Optional.empty();
    }

    default public boolean shouldRegister() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected Optional<ResourceLocation> id = Optional.empty();
        protected boolean shouldRegister = true;

        public Builder id(ResourceLocation id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Builder shouldRegister(boolean shouldRegister) {
            this.shouldRegister = shouldRegister;
            return this;
        }

        public IAPContext build() {
            return new IAPContext(){

                @Override
                public Optional<ResourceLocation> getRegistryName() {
                    return id;
                }

                @Override
                public boolean shouldRegister() {
                    return shouldRegister;
                }
            };
        }
    }
}

