/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.annotations.FieldReference;
import com.zeitheron.hammercore.annotations.RegistryName;
import com.zeitheron.hammercore.annotations.SimplyRegister;
import com.zeitheron.hammercore.api.IDontWantToRegisterTileEntity;
import com.zeitheron.hammercore.api.INoItemBlock;
import com.zeitheron.hammercore.api.ITileBlock;
import com.zeitheron.hammercore.api.blocks.IBlockItemRegisterListener;
import com.zeitheron.hammercore.api.blocks.INoBlockstate;
import com.zeitheron.hammercore.api.multipart.BlockMultipartProvider;
import com.zeitheron.hammercore.internal.SimpleRegisterKernelForMod;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.internal.ap.AnnotationProcessorRegistry;
import com.zeitheron.hammercore.internal.ap.IAPContext;
import com.zeitheron.hammercore.internal.blocks.IItemBlock;
import com.zeitheron.hammercore.internal.init.ItemsHC;
import com.zeitheron.hammercore.utils.IRegisterListener;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.forge.ICustomRegistrar;
import com.zeitheron.hammercore.utils.forge.RegisterEvent;
import com.zeitheron.hammercore.utils.forge.RegisterHook;
import com.zeitheron.hammercore.utils.java.tuples.Tuple2;
import com.zeitheron.hammercore.utils.java.tuples.Tuples;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleRegisterKernel {
    protected final String className;
    protected final SimpleRegisterKernelForMod container;
    protected Map<Class<?>, List<RegisterEntry>> fields;
    protected List<Tuple2<ICustomRegistrar, ResourceLocation>> customRegistrars;
    protected CreativeTabs assignedTab;
    protected boolean registeredItems;
    protected boolean registeredBlocks;

    public SimpleRegisterKernel(String className, SimpleRegisterKernelForMod container) {
        this.className = className;
        this.container = container;
    }

    public String className() {
        return this.className;
    }

    public List<Tuple2<ICustomRegistrar, ResourceLocation>> getCustomRegistrars() {
        if (this.customRegistrars != null) {
            return this.customRegistrars;
        }
        this.customRegistrars = new ArrayList<Tuple2<ICustomRegistrar, ResourceLocation>>();
        try {
            Class<?> ownerCls = Class.forName(this.className);
            String prefix = "";
            SimplyRegister sr = ownerCls.getAnnotation(SimplyRegister.class);
            if (sr != null) {
                prefix = sr.prefix();
            }
            for (Field field : ownerCls.getDeclaredFields()) {
                IAPContext.Builder ctxb = IAPContext.builder();
                boolean register = SimpleRegistration.doRegister(field);
                ctxb.shouldRegister(register);
                field.setAccessible(true);
                Object value = field.get(null);
                RegistryName key = field.getAnnotation(RegistryName.class);
                if (key != null) {
                    ResourceLocation regKey = new ResourceLocation(this.container.getModId(), prefix + key.value());
                    ctxb.id(regKey);
                    ICustomRegistrar ctr = Cast.cast(value, ICustomRegistrar.class);
                    if (register && ctr != null) {
                        this.customRegistrars.add(Tuples.immutable(ctr, regKey));
                    }
                }
                IAPContext ctx = ctxb.build();
                AnnotationProcessorRegistry.scan(ctx, field, value);
            }
            for (AccessibleObject accessibleObject : ownerCls.getDeclaredMethods()) {
                AnnotationProcessorRegistry.scan(IAPContext.DUMMY, (Method)accessibleObject);
            }
        }
        catch (Exception e) {
            HammerCore.LOG.error("Failed to register custom registrars from class {}", (Object)this.className, (Object)e);
        }
        return this.customRegistrars;
    }

    public Map<Class<?>, List<RegisterEntry>> getFields() {
        if (this.fields != null) {
            return this.fields;
        }
        this.fields = new HashMap();
        try {
            Class<?> ownerCls = Class.forName(this.className);
            String prefix = "";
            SimplyRegister sr = ownerCls.getAnnotation(SimplyRegister.class);
            if (sr != null) {
                prefix = sr.prefix();
                FieldReference tab = sr.creativeTab();
                this.assignedTab = Cast.cast(ReflectionUtil.getValue(tab.clazz(), tab.field()), CreativeTabs.class);
            }
            for (Field f : ownerCls.getDeclaredFields()) {
                if (!IForgeRegistryEntry.class.isAssignableFrom(f.getType()) || !Modifier.isStatic(f.getModifiers())) continue;
                boolean register = SimpleRegistration.doRegister(f);
                RegistryName key = f.getAnnotation(RegistryName.class);
                if (key == null) continue;
                f.setAccessible(true);
                IForgeRegistryEntry ctr = (IForgeRegistryEntry)Cast.cast(f.get(null));
                if (ctr == null) continue;
                ResourceLocation regKey = new ResourceLocation(this.container.getModId(), prefix + key.value());
                this.fields.computeIfAbsent(ctr.getRegistryType(), ignore -> new ArrayList()).add(new RegisterEntry(f, ctr, regKey, register));
            }
        }
        catch (Exception e) {
            HammerCore.LOG.error("Failed to register read class {}", (Object)this.className, (Object)e);
        }
        return this.fields;
    }

    public void registerItems() {
        this.register(new RegistryEvent.Register(GameData.ITEMS, ForgeRegistries.ITEMS));
    }

    public void registerBlocks() {
        this.register(new RegistryEvent.Register(GameData.BLOCKS, ForgeRegistries.BLOCKS));
    }

    protected void register(RegistryEvent.Register evt) {
        IForgeRegistry reg = evt.getRegistry();
        Class base = reg.getRegistrySuperType();
        List<RegisterEntry> toRegister = this.getFields().get(base);
        boolean blocks = base.equals(Block.class);
        boolean items = base.equals(Item.class);
        String modid = this.container.getModId();
        if (blocks && this.registeredBlocks) {
            return;
        }
        if (items && this.registeredItems) {
            return;
        }
        if (blocks) {
            this.registeredBlocks = true;
        }
        if (items) {
            this.registeredItems = true;
        }
        RegisterEvent evtHL = new RegisterEvent(evt);
        for (Tuple2<ICustomRegistrar, ResourceLocation> registrar : this.getCustomRegistrars()) {
            registrar.a().register(registrar.b(), evtHL);
        }
        if (toRegister != null) {
            try {
                for (RegisterEntry tup : toRegister) {
                    IForgeRegistryEntry<?> ctr = tup.entry;
                    ResourceLocation regKey = tup.id;
                    boolean doReg = tup.register;
                    IAPContext ctx = IAPContext.builder().shouldRegister(doReg).id(regKey).build();
                    AnnotationProcessorRegistry.scanReg(ctx, tup.field, ctr, false);
                    if (!doReg) continue;
                    ctr.setRegistryName(regKey);
                    if (items) {
                        Cast.optionally(ctr, Item.class).ifPresent(it -> {
                            it.func_77655_b(regKey.func_110624_b().concat(":").concat(regKey.func_110623_a()));
                            if (this.assignedTab != null) {
                                it.func_77637_a(this.assignedTab);
                            }
                            ItemsHC.items.add((Item)it);
                        });
                    } else if (blocks) {
                        Cast.optionally(ctr, Block.class).ifPresent(block -> {
                            Item i;
                            block.func_149663_c(regKey.func_110624_b().concat(":").concat(regKey.func_110623_a()));
                            if (this.assignedTab != null) {
                                block.func_149647_a(this.assignedTab);
                            }
                            Object ib = block instanceof BlockMultipartProvider ? ((BlockMultipartProvider)block).createItem() : (block instanceof IItemBlock ? ((IItemBlock)block).getItemBlock() : new ItemBlock(block));
                            if (!(block instanceof INoItemBlock)) {
                                if (ib != null) {
                                    ForgeRegistries.ITEMS.register(ib.setRegistryName(block.getRegistryName()));
                                    if (block instanceof IBlockItemRegisterListener) {
                                        ((IBlockItemRegisterListener)block).onItemBlockRegistered((Item)ib);
                                    }
                                }
                                if (ib instanceof IRegisterListener) {
                                    IRegisterListener rl = (IRegisterListener)ib;
                                    rl.onRegistered();
                                    RegisterHook.HookCollector.propagate(rl);
                                }
                            }
                            if (block instanceof INoBlockstate) {
                                HammerCore.renderProxy.noModel((Block)block);
                            }
                            if (!(block instanceof IDontWantToRegisterTileEntity)) {
                                if (block instanceof ITileBlock) {
                                    Class c = ((ITileBlock)block).getTileClass();
                                    if (TileEntity.func_190559_a(c) == null) {
                                        TileEntity.func_190560_a((String)(modid + ":" + c.getSimpleName().toLowerCase()), c);
                                    }
                                } else if (block instanceof ITileEntityProvider) {
                                    try {
                                        Class<?> c;
                                        ITileEntityProvider te = (ITileEntityProvider)block;
                                        TileEntity t = te.func_149915_a(null, 0);
                                        if (t != null && TileEntity.func_190559_a(c = t.getClass()) == null) {
                                            TileEntity.func_190560_a((String)(modid + ":" + c.getSimpleName().toLowerCase()), c);
                                        }
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (!(block instanceof INoItemBlock) && (i = Item.func_150898_a((Block)block)) != Items.field_190931_a) {
                                ItemsHC.items.add(i);
                                if (this.assignedTab != null) {
                                    i.func_77637_a(this.assignedTab);
                                }
                            }
                        });
                    }
                    reg.register((IForgeRegistryEntry)Cast.cast(ctr));
                    if (ctr instanceof IRegisterListener) {
                        IRegisterListener rl = (IRegisterListener)ctr;
                        rl.onRegistered();
                        RegisterHook.HookCollector.propagate(rl);
                    }
                    AnnotationProcessorRegistry.scanReg(ctx, tup.field, ctr, true);
                    HammerCore.LOG.debug("Registered {}: {} ({})", (Object)base.getSimpleName(), ctr, (Object)regKey);
                }
            }
            catch (Exception e) {
                HammerCore.LOG.error("Failed to register {} from class {}", (Object)base.getSimpleName(), (Object)this.className, (Object)e);
            }
        }
    }

    public static Map<String, SimpleRegisterKernelForMod> doScan(ASMDataTable table) {
        HashMap<String, SimpleRegisterKernelForMod> kernels = new HashMap<String, SimpleRegisterKernelForMod>();
        for (ASMDataTable.ASMData data : table.getAll(SimplyRegister.class.getCanonicalName())) {
            ModContainer mod = data.getCandidate().getContainedMods().stream().findFirst().orElse(null);
            if (mod == null) {
                HammerCore.LOG.warn("Skipping @SimplyRegister-annotated class {} since it does not belong to any mod.", (Object)data.getClassName());
                continue;
            }
            SimpleRegisterKernelForMod coll = kernels.computeIfAbsent(mod.getModId(), __ -> new SimpleRegisterKernelForMod(mod));
            coll.add(new SimpleRegisterKernel(data.getClassName(), coll));
            HammerCore.LOG.info("Applied @SimplyRegister to {}, which belongs to {} ({})", (Object)data.getClassName(), (Object)mod.getModId(), (Object)mod.getName());
        }
        for (SimpleRegisterKernelForMod kernelCollection : kernels.values()) {
            kernelCollection.sort(Comparator.comparing(SimpleRegisterKernel::className));
        }
        return kernels;
    }

    public boolean is(String modid) {
        return Objects.equals(this.container.getModId(), modid);
    }

    public static class RegisterEntry {
        public final Field field;
        public final IForgeRegistryEntry<?> entry;
        public final ResourceLocation id;
        public final boolean register;

        public RegisterEntry(Field field, IForgeRegistryEntry<?> entry, ResourceLocation id, boolean register) {
            this.field = field;
            this.entry = entry;
            this.id = id;
            this.register = register;
        }
    }
}

