/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture.gif;

import com.zeitheron.hammercore.client.utils.IImagePreprocessor;
import com.zeitheron.hammercore.client.utils.texture.TexLocUploader;
import com.zeitheron.hammercore.client.utils.texture.gif.GLGifInfo;
import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GifDecoder {
    public static GLGifInfo decodeGifIntoVideoMem(File gif, IImagePreprocessor ... proc) throws IOException {
        return GifDecoder.decodeGifIntoVideoMem(gif.toURI().toURL(), proc);
    }

    public static GLGifInfo decodeGifIntoVideoMem(URL gif, IImagePreprocessor ... proc) throws IOException {
        return GifDecoder.decodeGifIntoVideoMem(gif.openStream(), proc);
    }

    public static GLGifInfo decodeGifIntoVideoMem(InputStream gif, IImagePreprocessor ... proc) throws IOException {
        TwoTuple<ImageFrame[], int[]> info = GifDecoder.readGIF(gif);
        ImageFrame[] frames = info.get1();
        ResourceLocation[] gl = new ResourceLocation[frames.length];
        for (int i = 0; i < gl.length; ++i) {
            int fid = i;
            ResourceLocation rl = new ResourceLocation("hammercore", "gifs/" + Integer.toHexString(gif.hashCode()) + "-" + i + ".png");
            BufferedImage cap = frames[fid].getImage();
            for (IImagePreprocessor p : proc) {
                cap = p.process(cap);
            }
            BufferedImage fimg = cap;
            Minecraft.func_71410_x().func_152343_a(() -> TexLocUploader.upload(rl, fimg));
            TexLocUploader.cleanupAfterLogoff(rl, new Runnable[0]);
            gl[i] = rl;
        }
        return new GLGifInfo(gl, frames[0].getImage().getWidth(), frames[0].getImage().getHeight(), info.get2());
    }

    private static TwoTuple<ImageFrame[], int[]> readGIF(InputStream in) throws IOException {
        IIOMetadataNode screenDescriptor;
        IIOMetadataNode globalRoot;
        NodeList globalScreenDescriptor;
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream stream = ImageIO.createImageInputStream(in);
        reader.setInput(stream);
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(2);
        IntArrayList delays = new IntArrayList(2);
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        if (metadata != null && (globalScreenDescriptor = (globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("LogicalScreenDescriptor")) != null && globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
            width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
            height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
        }
        BufferedImage master = null;
        Graphics2D masterGraphics = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = 1;
            try {
                delay = Integer.parseInt(gce.getAttribute("delayTime"));
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else {
                NodeList children = root.getChildNodes();
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.valueOf(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.valueOf(map.getNamedItem("imageTopPosition").getNodeValue());
                }
            }
            masterGraphics.drawImage((Image)image, x, y, null);
            BufferedImage copy = new BufferedImage(master.getColorModel(), master.copyData(null), master.isAlphaPremultiplied(), null);
            frames.add(new ImageFrame(copy, disposal));
            delays.add(delay);
            if (disposal.equals("restoreToPrevious")) {
                BufferedImage from = null;
                for (int i = frameIndex - 1; i >= 0; --i) {
                    if (((ImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                    from = ((ImageFrame)frames.get(i)).getImage();
                    break;
                }
                master = new BufferedImage(from.getColorModel(), from.copyData(null), from.isAlphaPremultiplied(), null);
                masterGraphics = master.createGraphics();
                masterGraphics.setBackground(new Color(0, 0, 0, 0));
            } else if (disposal.equals("restoreToBackgroundColor")) {
                masterGraphics.clearRect(x, y, image.getWidth(), image.getHeight());
            }
            ++frameIndex;
        }
        reader.dispose();
        return new TwoTuple<ImageFrame[], int[]>(frames.toArray(new ImageFrame[frames.size()]), delays.toIntArray());
    }

    private static class ImageFrame {
        private final BufferedImage image;
        private final String disposal;

        public ImageFrame(BufferedImage image, String disposal) {
            this.image = image;
            this.disposal = disposal;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public String getDisposal() {
            return this.disposal;
        }
    }
}

