/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.texture.def;

import com.zeitheron.hammercore.client.utils.IImagePreprocessor;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.client.utils.texture.def.IBindableImage;
import com.zeitheron.hammercore.client.utils.texture.def.ImagePuller;
import com.zeitheron.hammercore.client.utils.texture.gif.GLGifInfo;
import com.zeitheron.hammercore.client.utils.texture.gif.GifDecoder;
import com.zeitheron.hammercore.lib.zlib.utils.Threading;
import com.zeitheron.hammercore.lib.zlib.web.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class BindableImageGif
implements IBindableImage {
    public final String url;
    public GLGifInfo info;
    private boolean init = false;

    public BindableImageGif(String url) {
        this.url = url;
    }

    private void init(IImagePreprocessor ... proc) {
        this.init = true;
        Threading.createAndStart("DwnGIF$" + this.url, () -> {
            try (InputStream in = HttpRequest.get(this.url).userAgent("HammerCore/12.2.58").stream();){
                this.info = GifDecoder.decodeGifIntoVideoMem(in, proc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public boolean glBind(double timeInTicks, IImagePreprocessor ... proc) {
        int frame;
        if (!this.init) {
            this.init(proc);
        }
        if (this.info == null) {
            UtilsFX.bindTexture(ImagePuller.nosignal_gl);
            return true;
        }
        float mod = 10.0f;
        long milliTime = (long)(timeInTicks * 50.0);
        if (milliTime < 0L) {
            milliTime = -milliTime;
        }
        if ((frame = this.info.getFrameFromMS(milliTime)) < 0) {
            UtilsFX.bindTexture(ImagePuller.nosignal_gl);
            return true;
        }
        UtilsFX.bindTexture(this.info.tex[frame % this.info.tex.length]);
        return true;
    }

    @Override
    public boolean isSameURL(String url) {
        return Objects.equals(url, this.url);
    }
}

