/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.gl.shading;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.events.ResourceManagerReloadEvent;
import com.zeitheron.hammercore.client.render.shader.GlShaderStack;
import com.zeitheron.hammercore.client.utils.gl.GLBuffer;
import com.zeitheron.hammercore.client.utils.gl.shading.InitializeShadersEvent;
import com.zeitheron.hammercore.client.utils.gl.shading.ShaderSource;
import com.zeitheron.hammercore.client.utils.gl.shading.ShaderVar;
import com.zeitheron.hammercore.utils.OnetimeCaller;
import com.zeitheron.hammercore.utils.base.EvtBus;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class VariableShaderProgram {
    public static boolean hasInitialized;
    private static final List<VariableShaderProgram> PROGRAMS;
    private static final Map<ResourceLocation, VariableShaderProgram> PROGRAM_REGISTRY;
    private final Int2ObjectArrayMap<ShaderSource> sourcesStatic = new Int2ObjectArrayMap();
    private final List<Consumer<IShaderLinker>> linkers = new ArrayList<Consumer<IShaderLinker>>();
    private final Int2ObjectArrayMap<ShaderSource> sources = new Int2ObjectArrayMap();
    private final List<ShaderVar<?>> variables = new ArrayList();
    private final Object2IntArrayMap<String> uniformCache = new Object2IntArrayMap();
    private final List<Consumer<VariableShaderProgram>> onBind = new ArrayList<Consumer<VariableShaderProgram>>();
    private final List<Consumer<VariableShaderProgram>> onCompilationFailed = new ArrayList<Consumer<VariableShaderProgram>>();
    private Integer program;
    private ResourceLocation id;
    private boolean doGLLog = true;
    private boolean hasCompiled;
    private boolean compilationFailed;
    private final List<Throwable> compilationErrors = new ArrayList<Throwable>();
    public final List<String> uniformNames = new ArrayList<String>();
    private static final OnetimeCaller initShaders;

    public VariableShaderProgram id(ResourceLocation id) {
        if (this.id == null) {
            if (PROGRAM_REGISTRY.containsKey(id)) {
                throw new RuntimeException("Duplicate shader pipeline id: " + id);
            }
        } else {
            throw new RuntimeException("ID already assigned to shader pipe: " + this.id + " (tried to override to " + id + ")");
        }
        this.id = id;
        PROGRAM_REGISTRY.put(id, this);
        return this;
    }

    public VariableShaderProgram doGLLog(boolean flag) {
        this.doGLLog = flag;
        return this;
    }

    public VariableShaderProgram subscribe4Events() {
        if (!PROGRAMS.contains(this)) {
            PROGRAMS.add(this);
        }
        return this;
    }

    public VariableShaderProgram addVariable(ShaderVar<?> var) {
        var.setProgram(this);
        this.variables.add(var);
        return this;
    }

    public VariableShaderProgram onBind(Consumer<VariableShaderProgram> onBind) {
        this.onBind.add(onBind);
        return this;
    }

    public VariableShaderProgram dynamicLinker(Consumer<IShaderLinker> linker) {
        this.linkers.add(linker);
        return this;
    }

    public VariableShaderProgram linkGeometrySource(ShaderSource src) {
        return this.linkSource(36313, src);
    }

    public VariableShaderProgram linkVertexSource(ShaderSource src) {
        return this.linkSource(OpenGlHelper.field_153209_q, src);
    }

    public VariableShaderProgram linkFragmentSource(ShaderSource src) {
        return this.linkSource(OpenGlHelper.field_153210_r, src);
    }

    public VariableShaderProgram linkSource(int type, ShaderSource src) {
        this.sourcesStatic.put(type, (Object)src);
        return this;
    }

    public VariableShaderProgram onCompilationFailed(Consumer<VariableShaderProgram> errorHandler) {
        this.onCompilationFailed.add(errorHandler);
        return this;
    }

    protected void createProgram() {
        this.hasCompiled = false;
        this.compilationFailed = false;
        this.compilationErrors.clear();
        try {
            if (this.program != null) {
                OpenGlHelper.func_153187_e((int)this.program);
            }
            this.uniformCache.clear();
            this.program = OpenGlHelper.func_153183_d();
            IntArrayList shaders = new IntArrayList();
            this.sources.clear();
            this.sources.putAll(this.sourcesStatic);
            for (Consumer<IShaderLinker> linker : this.linkers) {
                linker.accept((arg_0, arg_1) -> this.sources.put(arg_0, arg_1));
            }
            IntIterator intIterator = this.sources.keySet().iterator();
            while (intIterator.hasNext()) {
                int key = (Integer)intIterator.next();
                int shader = OpenGlHelper.func_153195_b((int)key);
                if (shader == 0) continue;
                byte[] abyte = ((ShaderSource)this.sources.get(key)).read(this.variables).getBytes(StandardCharsets.UTF_8);
                ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)abyte.length);
                bytebuffer.put(abyte);
                bytebuffer.position(0);
                OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)bytebuffer);
                OpenGlHelper.func_153170_c((int)shader);
                String gl = OpenGlHelper.func_153158_d((int)shader, (int)32768);
                if (OpenGlHelper.func_153157_c((int)shader, (int)OpenGlHelper.field_153208_p) == 0) {
                    RuntimeException err2 = new RuntimeException("Failed to load shader(#" + Integer.toHexString(key) + ") source " + this.sources.get(key) + ":\n" + gl);
                    this.compilationErrors.add(err2);
                    OpenGlHelper.func_153180_a((int)shader);
                    continue;
                }
                if (!gl.isEmpty()) {
                    HammerCore.LOG.warn("GL log: for shader(#{}) source {}: {}", (Object)Integer.toHexString(key), this.sources.get(key), (Object)gl);
                }
                OpenGlHelper.func_153178_b((int)this.program, (int)shader);
                shaders.add(shader);
            }
            OpenGlHelper.func_153179_f((int)this.program);
            String s = OpenGlHelper.func_153166_e((int)this.program, (int)32768);
            if (!s.isEmpty() && this.doGLLog) {
                System.out.println("GL LOG: " + s.trim());
            }
            IntListIterator intListIterator = shaders.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                OpenGlHelper.func_153180_a((int)i);
            }
            this.hasCompiled = true;
            this.variables.forEach(v -> {
                v.hasChanged = false;
            });
            this.compilationFailed = false;
            this.collectUniforms();
        }
        catch (Throwable err3) {
            this.compilationErrors.add(err3);
        }
        if (!this.compilationErrors.isEmpty()) {
            if (this.program != null) {
                OpenGlHelper.func_153187_e((int)this.program);
            }
            this.program = null;
            this.hasCompiled = false;
            this.compilationFailed = true;
            this.compilationErrors.forEach(err -> HammerCore.LOG.error("Shader {} error:", (Object)this.getId(), err));
            this.onCompilationFailed.forEach(c -> c.accept(this));
        }
    }

    public void collectUniforms() {
        this.uniformNames.clear();
        if (this.program == null) {
            return;
        }
        int ufs = OpenGlHelper.func_153175_a((int)this.program, (int)35718);
        for (int i = 0; i < ufs; ++i) {
            this.uniformNames.add(GL20.glGetActiveUniform((int)this.program, (int)i, (int)128));
        }
    }

    public Integer getProgramId() {
        return this.program;
    }

    public void update() {
        if (this.program != null && this.variables.stream().peek(ShaderVar::update).anyMatch(v -> v.hasChanged)) {
            this.createProgram();
        }
    }

    public void onReload() {
        this.createProgram();
    }

    public boolean hasCompiled() {
        return this.hasCompiled;
    }

    public boolean hasCompilationFailed() {
        return this.compilationFailed;
    }

    public List<Throwable> getCompilationErrors() {
        return this.compilationErrors;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public int getUniformLocation(String location) {
        if (this.program == null) {
            return 0;
        }
        if (!this.uniformCache.containsKey((Object)location)) {
            int loc = OpenGlHelper.func_153194_a((int)this.program, (CharSequence)location);
            if (loc == -1) {
                HammerCore.LOG.info("Attempted to access unknown uniform location {} in shader {}! This is not going to end well!", (Object)location, (Object)this.id);
                Thread.dumpStack();
            }
            this.uniformCache.put((Object)location, loc);
        }
        return this.uniformCache.getInt((Object)location);
    }

    public void setUniform(String uniform, int value) {
        if (!this.hasCompiled) {
            return;
        }
        OpenGlHelper.func_153163_f((int)this.getUniformLocation(uniform), (int)value);
    }

    public void setUniform(String uniform, boolean value) {
        if (!this.hasCompiled) {
            return;
        }
        OpenGlHelper.func_153163_f((int)this.getUniformLocation(uniform), (int)(value ? 1 : 0));
    }

    public void setUniform(String uniform, float value) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform1f((int)this.getUniformLocation(uniform), (float)value);
    }

    public void setUniform(String uniform, int v1, int v2) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform2i((int)this.getUniformLocation(uniform), (int)v1, (int)v2);
    }

    public void setUniform(String uniform, int v1, int v2, int v3) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform3i((int)this.getUniformLocation(uniform), (int)v1, (int)v2, (int)v3);
    }

    public void setUniform(String uniform, float v1, float v2) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform2f((int)this.getUniformLocation(uniform), (float)v1, (float)v2);
    }

    public void setUniform(String uniform, float v1, float v2, float v3) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform3f((int)this.getUniformLocation(uniform), (float)v1, (float)v2, (float)v3);
    }

    public void setUniform(String uniform, float v1, float v2, float v3, float v4) {
        if (!this.hasCompiled) {
            return;
        }
        GL20.glUniform4f((int)this.getUniformLocation(uniform), (float)v1, (float)v2, (float)v3, (float)v4);
    }

    public void setBuffer(String blockName, GLBuffer buffer) {
        if (!this.hasCompiled) {
            return;
        }
        buffer.bindToShader(this.program, 0, blockName);
    }

    public void bindShader() {
        if (this.compilationFailed) {
            return;
        }
        if (this.program == null) {
            this.createProgram();
        }
        if (!this.hasCompiled) {
            return;
        }
        OpenGlHelper.func_153161_d((int)this.program);
        if (!this.onBind.isEmpty()) {
            this.onBind.forEach(c -> c.accept(this));
        }
    }

    public void unbindShader() {
        OpenGlHelper.func_153161_d((int)0);
    }

    @SubscribeEvent
    public static void reloadShaders(ResourceManagerReloadEvent e) {
        if (hasInitialized && e.isType((IResourceType)VanillaResourceType.SHADERS)) {
            VariableShaderProgram.reload();
        }
    }

    public static void reload() {
        Minecraft.func_71410_x().func_152344_a(() -> {
            initShaders.call();
            HammerCore.LOG.info("Reloading {} variable shader programs.", (Object)PROGRAMS.size());
            PROGRAMS.forEach(VariableShaderProgram::onReload);
        });
    }

    @SubscribeEvent
    public static void tickShader(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            PROGRAMS.forEach(VariableShaderProgram::update);
        }
    }

    public static VariableShaderProgram byId(ResourceLocation id) {
        return PROGRAM_REGISTRY.get(id);
    }

    public boolean isActive() {
        return this.hasCompiled && this.program != null && this.program.equals(GlShaderStack.glsActiveProgram());
    }

    static {
        PROGRAMS = new ArrayList<VariableShaderProgram>();
        PROGRAM_REGISTRY = new HashMap<ResourceLocation, VariableShaderProgram>();
        initShaders = OnetimeCaller.of(() -> EvtBus.post(MinecraftForge.EVENT_BUS, new InitializeShadersEvent()));
    }

    @SideOnly(value=Side.CLIENT)
    public static class ShaderErrorToast
    implements IToast {
        private String title;
        private String subtitle;
        private long firstDrawTime;
        private boolean newDisplay;

        public ShaderErrorToast(ITextComponent titleComponent, @Nullable ITextComponent subtitleComponent) {
            this.title = titleComponent.func_150260_c();
            this.subtitle = subtitleComponent == null ? null : subtitleComponent.func_150260_c();
        }

        public IToast.Visibility func_193653_a(GuiToast toastGui, long delta) {
            if (this.newDisplay) {
                this.firstDrawTime = delta;
                this.newDisplay = false;
            }
            toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.func_73729_b(0, 0, 0, 64, 160, 32);
            if (this.subtitle == null) {
                toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 18, 12, -256);
            } else {
                toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 18, 7, -256);
                toastGui.func_192989_b().field_71466_p.func_78276_b(this.subtitle, 18, 18, -1);
            }
            return delta - this.firstDrawTime < 5000L ? IToast.Visibility.SHOW : IToast.Visibility.HIDE;
        }

        public void setDisplayedText(ITextComponent titleComponent, @Nullable ITextComponent subtitleComponent) {
            this.title = titleComponent.func_150260_c();
            this.subtitle = subtitleComponent == null ? null : subtitleComponent.func_150260_c();
            this.newDisplay = true;
        }
    }

    public static enum ToastCompilationErrorHandler implements Consumer<VariableShaderProgram>
    {
        INSTANCE;


        @Override
        public void accept(VariableShaderProgram program) {
            if (program.hasCompilationFailed()) {
                int errors = program.getCompilationErrors().size();
                ShaderErrorToast toast = new ShaderErrorToast((ITextComponent)new TextComponentString(errors + " Shader Error" + (errors > 1 ? "s" : "")), (ITextComponent)new TextComponentString(program.getId() + " failed. :<"));
                Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)toast);
            }
        }
    }

    public static interface IShaderLinker {
        public void link(int var1, ShaderSource var2);
    }
}

