/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.gl.shading;

import com.zeitheron.hammercore.client.utils.gl.shading.VariableShaderProgram;
import java.util.Objects;

public abstract class ShaderVar<STATE> {
    public boolean hasChanged;
    final String key;
    STATE state;
    String value;
    VariableShaderProgram program;

    public ShaderVar(String key) {
        this.key = key;
    }

    protected abstract STATE getState();

    protected abstract String compute(STATE var1);

    public void update() {
        STATE st = this.getState();
        if (!Objects.equals(this.state, st)) {
            this.state = st;
            String nv = this.compute(st);
            if (!Objects.equals(nv, this.value)) {
                this.value = nv;
                this.hasChanged = true;
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    void setProgram(VariableShaderProgram program) {
        if (this.program != null) {
            throw new IllegalStateException(this + " is already assigned to shader program " + this.program);
        }
        this.program = program;
    }

    public VariableShaderProgram getProgram() {
        return this.program;
    }

    public String toString() {
        return "ShaderVar{key='" + this.key + '\'' + ", program=" + this.program + '}';
    }
}

