/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.world;

import com.zeitheron.hammercore.client.render.world.VirtualWorld;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.Rectangle;

public class VirtualWorldRenderer {
    private static final boolean scissorAvailable = GLContext.getCapabilities().OpenGL20;
    public static int guiLeft = 0;
    public static int guiTop = 0;

    public static void renderVirtualWorld(VirtualWorld world, Minecraft mc, Rectangle panel, float rotX, float rotY, float zoom) {
        GlStateManager.func_179126_j();
        boolean shouldCut = panel.getHeight() == 0 && panel.getWidth() == 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(panel.getX() + panel.getWidth() / 2), (float)(panel.getY() + panel.getHeight() / 2), (float)10.0f);
        double sc = Math.sqrt((double)zoom + 99.0) - 9.0;
        GlStateManager.func_179139_a((double)(-sc), (double)(-sc), (double)(-sc));
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        BlockRendererDispatcher brd = mc.func_175602_ab();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            for (BlockPos pos : world.tiles.VALUES.keySet()) {
                IBlockState iblockstate = world.func_180495_p(pos);
                Block block = iblockstate.func_177230_c();
                if (!block.canRenderInLayer(iblockstate, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                if (block.func_176223_P().func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                brd.func_175018_a(iblockstate, pos, (IBlockAccess)world, vb);
            }
        }
        ForgeHooksClient.setRenderLayer(null);
        if (scissorAvailable && shouldCut) {
            ScaledResolution sr = new ScaledResolution(mc);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((guiLeft + panel.getX()) * sr.func_78325_e()), (int)(mc.field_71440_d - (guiTop + panel.getY() + panel.getHeight()) * sr.func_78325_e()), (int)(panel.getWidth() * sr.func_78325_e()), (int)(panel.getHeight() * sr.func_78325_e()));
        }
        tess.func_78381_a();
        float p = mc.func_184121_ak();
        for (BlockPos pos : world.tiles.VALUES.keySet()) {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) continue;
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(te, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), p);
        }
        if (scissorAvailable && shouldCut) {
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179097_i();
    }
}

