/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.world;

import com.zeitheron.hammercore.client.render.world.VirtualWorld;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class VirtualWorldRender {
    private static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    private static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final VirtualWorld world;
    private Predicate<BlockPos> renderFilter;
    private BlockPos lastHitBlock;
    public Consumer<VirtualWorldRender> preRender = null;
    public Consumer<VirtualWorldRender> postRender = null;
    public BiConsumer<VirtualWorldRender, BlockPos> renderBlockHit = null;

    public VirtualWorldRender(VirtualWorld world) {
        this.world = world;
    }

    public BlockPos getLastHitBlock() {
        return this.lastHitBlock;
    }

    public void render(int x, int y, int width, int height, int backgroundColor) {
        Vec2f mousePosition = VirtualWorldRender.setupCamera(x, y, width, height, backgroundColor);
        if (this.preRender != null) {
            this.preRender.accept(this);
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRendererDispatcher dispatcher = minecraft.func_175602_ab();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockPos pos : this.world.states.VALUES.keySet()) {
            if (this.renderFilter != null && !this.renderFilter.test(pos)) continue;
            IBlockState blockState = this.world.func_180495_p(pos);
            dispatcher.func_175018_a(blockState, pos, (IBlockAccess)this.world, buffer);
        }
        tessellator.func_78381_a();
        for (BlockPos pos : this.world.tiles.VALUES.keySet()) {
            TileEntity tile;
            if (this.renderFilter != null && !this.renderFilter.test(pos) || (tile = this.world.func_175625_s(pos)) == null) continue;
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tile, Minecraft.func_71410_x().func_184121_ak(), -1);
        }
        this.lastHitBlock = mousePosition != null ? this.handleMouseHit(mousePosition) : null;
        if (this.lastHitBlock != null && this.renderBlockHit != null) {
            this.renderBlockHit.accept(this, this.lastHitBlock);
        }
        if (this.postRender != null) {
            this.postRender.accept(this);
        }
        VirtualWorldRender.resetCamera();
    }

    private BlockPos handleMouseHit(Vec2f mousePosition) {
        GL11.glReadPixels((int)((int)mousePosition.field_189982_i), (int)((int)mousePosition.field_189983_j), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject((float)mousePosition.field_189982_i, (float)mousePosition.field_189983_j, (float)pixelDepth, (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        if (posY < -100.0f) {
            return null;
        }
        BlockPos pos = new BlockPos((double)posX, (double)posY, (double)posZ);
        if (this.world.func_175623_d(pos)) {
            for (EnumFacing offset : EnumFacing.field_82609_l) {
                BlockPos relative = pos.func_177972_a(offset);
                if (this.world.func_175623_d(relative)) continue;
                pos = relative;
                break;
            }
        }
        if (this.world.func_175623_d(pos)) {
            return null;
        }
        return pos;
    }

    public static Vec2f setupCamera(int x, int y, int width, int height, int skyColor) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc);
        GlStateManager.func_179123_a();
        mc.field_71460_t.func_175072_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        int windowWidth = (int)((double)width / ((double)resolution.func_78326_a() * 1.0) * (double)mc.field_71443_c);
        int windowHeight = (int)((double)height / ((double)resolution.func_78328_b() * 1.0) * (double)mc.field_71440_d);
        int windowX = (int)((double)x / ((double)resolution.func_78326_a() * 1.0) * (double)mc.field_71443_c);
        int windowY = mc.field_71440_d - (int)((double)y / ((double)resolution.func_78328_b() * 1.0) * (double)mc.field_71440_d) - windowHeight;
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        Vec2f mousePosition = null;
        if (mouseX >= windowX && mouseY >= windowY && mouseX - windowX < windowWidth && mouseY - windowY < windowHeight) {
            mousePosition = new Vec2f((float)mouseX, (float)mouseY);
        }
        GlStateManager.func_179083_b((int)windowX, (int)windowY, (int)windowWidth, (int)windowHeight);
        if (skyColor >= 0) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)windowX, (int)windowY, (int)windowWidth, (int)windowHeight);
            RenderUtil.setGlClearColorFromInt(skyColor, 255);
            GlStateManager.func_179086_m((int)16640);
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GLU.gluLookAt((float)0.0f, (float)0.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        return mousePosition;
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179083_b((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }
}

