/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.world;

import com.zeitheron.hammercore.client.render.world.VirtualWorldRender;
import com.zeitheron.hammercore.utils.XYZMap;
import com.zeitheron.hammercore.utils.base.Cast;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VirtualWorld
implements IBlockAccess {
    public XYZMap<TileEntity> tiles = new XYZMap();
    public XYZMap<IBlockState> states = new XYZMap();
    public XYZMap<Biome> biomes = new XYZMap();
    public XYZMap<Integer> colors = new XYZMap();
    private final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
    private final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);
    Object render;

    public BlockPos[] getAllPlacedStatePositions() {
        return this.states.toKeyArray();
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.tiles.getOnPos(pos);
    }

    public void setTileEntity(BlockPos pos, TileEntity tile) {
        this.tiles.setOnPos(pos, tile);
        this.indexPos(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int light) {
        Integer actual = this.colors.getOnPos(pos);
        if (actual == null) {
            actual = 0xF000F0;
            this.colors.setOnPos(pos, actual);
        }
        return actual;
    }

    public void setCombinedLight(BlockPos pos, int light) {
        this.colors.setOnPos(pos, light);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState actual = this.states.getOnPos(pos);
        if (actual == null) {
            actual = Blocks.field_150350_a.func_176223_P();
            this.states.setOnPos(pos, actual);
        }
        return actual;
    }

    public void setBlockState(BlockPos pos, IBlockState state) {
        this.states.setOnPos(pos, state);
        if (state.func_177230_c() != Blocks.field_150350_a) {
            this.indexPos(pos);
        }
        if (state.func_177230_c().hasTileEntity(state)) {
            this.setTileEntity(pos, state.func_177230_c().createTileEntity(null, state));
        }
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
    }

    public Biome func_180494_b(BlockPos pos) {
        Biome actual = this.biomes.getOnPos(pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        if (actual == null) {
            actual = Biomes.field_76772_c;
            this.biomes.setOnPos(pos, actual);
        }
        return actual;
    }

    public void setBiome(BlockPos pos, Biome biome) {
        this.biomes.setOnPos(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()), biome);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return WorldType.field_77137_b;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _unknown) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    private void indexPos(BlockPos pos) {
        this.minPos.setX(Math.min(this.minPos.getX(), (float)pos.func_177958_n()));
        this.minPos.setY(Math.min(this.minPos.getY(), (float)pos.func_177956_o()));
        this.minPos.setZ(Math.min(this.minPos.getZ(), (float)pos.func_177952_p()));
        this.maxPos.setX(Math.max(this.maxPos.getX(), (float)pos.func_177958_n()));
        this.maxPos.setY(Math.max(this.maxPos.getY(), (float)pos.func_177956_o()));
        this.maxPos.setZ(Math.max(this.maxPos.getZ(), (float)pos.func_177952_p()));
    }

    public void clear() {
        this.biomes.clear();
        this.colors.clear();
        this.states.clear();
        this.tiles.clear();
        this.minPos.set(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
        this.maxPos.set(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);
    }

    public Vector3f getSize() {
        Vector3f result = new Vector3f();
        result.setX(this.maxPos.getX() - this.minPos.getX() + 1.0f);
        result.setY(this.maxPos.getY() - this.minPos.getY() + 1.0f);
        result.setZ(this.maxPos.getZ() - this.minPos.getZ() + 1.0f);
        return result;
    }

    public Vector3f getMinPos() {
        return this.minPos;
    }

    public Vector3f getMaxPos() {
        return this.maxPos;
    }

    @SideOnly(value=Side.CLIENT)
    public VirtualWorldRender getRender() {
        VirtualWorldRender vwr = Cast.cast(this.render, VirtualWorldRender.class);
        if (vwr == null) {
            vwr = new VirtualWorldRender(this);
            this.render = vwr;
        }
        return vwr;
    }
}

