/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.item;

import com.zeitheron.hammercore.client.render.item.IItemRender;
import com.zeitheron.hammercore.internal.init.ItemsHC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum ItemRenderingHandler {
    INSTANCE;

    private final Map<Item, IItemRender> renders = new HashMap<Item, IItemRender>();
    private final Map<Item, List<IItemRender>> renderHooks = new HashMap<Item, List<IItemRender>>();

    public void bindItemRender(Item item, IItemRender render) {
        List<IItemRender> hk = this.renderHooks.get(item);
        if (hk == null) {
            hk = new ArrayList<IItemRender>();
            this.renderHooks.put(item, hk);
        }
        hk.clear();
        hk.add(render);
        Minecraft.func_71410_x().func_175599_af().func_175048_a(item, 0, "chest");
    }

    public void setItemRender(Item item, IItemRender render) {
        List<IItemRender> hk = this.renderHooks.get(item);
        if (hk == null) {
            hk = new ArrayList<IItemRender>();
            this.renderHooks.put(item, hk);
        }
        hk.clear();
        hk.add(render);
        ItemsHC.rendered_items.add(item);
        ItemsHC.items.remove(item);
    }

    public void appendItemRender(Item item, IItemRender render) {
        List<IItemRender> hk = this.renderHooks.get(item);
        if (hk == null) {
            hk = new ArrayList<IItemRender>();
            this.renderHooks.put(item, hk);
        }
        hk.add(render);
    }

    public void applyItemRender(IItemRender render, Predicate<Item> applier) {
        GameRegistry.findRegistry(Item.class).getValuesCollection().stream().filter(applier).forEach(it -> this.appendItemRender((Item)it, render));
    }

    public boolean canRender(Item item) {
        return this.getRender(item) != null;
    }

    public IItemRender getRender(Item item) {
        return this.renders.get(item);
    }

    public List<IItemRender> getRenderHooks(Item item) {
        List<IItemRender> hk = this.renderHooks.get(item);
        return hk != null ? hk : Collections.emptyList();
    }
}

