/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.model.mc;

import com.google.common.collect.ImmutableList;
import com.zeitheron.hammercore.client.model.mc.ISimplifiedModel;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class HackyBakedModel
implements IBakedModel {
    public static final List<BakedQuad> QUADS = Collections.emptyList();
    public final ISimplifiedModel model;
    private final Pair<IBakedModel, Matrix4f> selfPair;
    private ItemCameraTransforms.TransformType currentPerspective;
    private ItemStack lastStack;
    private EntityLivingBase lastEntity;
    VertexFormat defaultVertexFormat = DefaultVertexFormats.field_176599_b;

    public HackyBakedModel(ISimplifiedModel model) {
        this.model = model;
        this.selfPair = Pair.of((Object)this, null);
    }

    public HackyBakedModel(@Nonnull ISimplifiedModel renderer, @Nonnull VertexFormat defVertexFormat) {
        this(renderer);
        this.defaultVertexFormat = defVertexFormat;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        this.model.handleBlockState(state, side, rand);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_78381_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.model.getTexture());
        this.model.renderModel(0.0f);
        this.model.postRender();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179121_F();
        this.currentPerspective = null;
        this.lastStack = null;
        this.lastEntity = null;
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, this.defaultVertexFormat);
        return QUADS;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideListHandler.INSTANCE_HACKY.setModelBaseWrapper(this);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model.getCameraTransforms();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.currentPerspective = cameraTransformType;
        Pair<? extends IBakedModel, Matrix4f> pair = this.model.handlePerspective(cameraTransformType, this.selfPair);
        if (this.model.useVanillaCameraTransform()) {
            boolean isLeft = HackyBakedModel.isLeftHand(cameraTransformType);
            ItemCameraTransforms.func_188034_a((ItemTransformVec3f)this.func_177552_f().func_181688_b(cameraTransformType), (boolean)isLeft);
        }
        return pair;
    }

    public static boolean isFirstPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
    }

    public static boolean isThirdPerson(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isEntityRender(ItemCameraTransforms.TransformType type) {
        return HackyBakedModel.isFirstPerson(type) || HackyBakedModel.isThirdPerson(type);
    }

    public static boolean isLeftHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
    }

    public static boolean isRightHand(ItemCameraTransforms.TransformType type) {
        return type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isItemRender(ItemCameraTransforms.TransformType type) {
        return type == null || type == ItemCameraTransforms.TransformType.GROUND || type == ItemCameraTransforms.TransformType.NONE;
    }

    private static final class ItemOverrideListHandler
    extends ItemOverrideList {
        private static final ItemOverrideListHandler INSTANCE_HACKY = new ItemOverrideListHandler();
        private HackyBakedModel modelBaseWrapper;

        private ItemOverrideListHandler() {
            super((List)ImmutableList.of());
        }

        private ItemOverrideListHandler setModelBaseWrapper(HackyBakedModel model) {
            this.modelBaseWrapper = model;
            return this;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            this.modelBaseWrapper.lastStack = stack;
            this.modelBaseWrapper.lastEntity = entity;
            this.modelBaseWrapper.model.handleItemState(stack, world, entity);
            return originalModel;
        }
    }
}

