/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.gui;

import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.client.utils.texture.gui.GuiTexBakery;
import com.zeitheron.hammercore.client.utils.texture.gui.theme.GuiTheme;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.opengl.GL11;

public class GuiWidgets {
    public static final ResourceLocation TEXTURE = new ResourceLocation("hammercore", "textures/gui/widgets.png");
    public static final long fullCycle = 1500L;

    public static List<String> createTooltipForFluidTank(FluidTank tank) {
        FluidStack fs = tank.getFluid();
        if (fs != null) {
            String mod = "Unknown";
            ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(FluidRegistry.getModId((FluidStack)fs));
            if (mc != null) {
                mod = mc.getName();
            }
            return Arrays.asList(fs.getLocalizedName(), TextFormatting.GRAY + String.format("%,d / %,d mB", fs.amount, tank.getCapacity()), TextFormatting.BLUE.toString() + TextFormatting.ITALIC + mod);
        }
        return Arrays.asList("Empty", TextFormatting.GRAY + String.format("%,d / %,d mB", 0, tank.getCapacity()));
    }

    public static void drawFurnaceArrow(float x, float y, double l) {
        UtilsFX.bindTexture("textures/gui/def_widgets.png");
        int col = GuiTheme.current().slotColor;
        GL11.glColor4f((float)ColorHelper.getRed(col), (float)ColorHelper.getGreen(col), (float)ColorHelper.getBlue(col), (float)1.0f);
        RenderUtil.drawTexturedModalRect(x, y, 0.0, 14.0, 22.0, 16.0);
        RenderUtil.drawTexturedModalRect(x, y, 0.0, 30.0, l * 24.0, 16.0);
        col = GuiTheme.current().getColor(1);
        GL11.glColor4f((float)ColorHelper.getRed(col), (float)ColorHelper.getGreen(col), (float)ColorHelper.getBlue(col), (float)1.0f);
        RenderUtil.drawTexturedModalRect(x, y, 0.0, 14.0, l * 24.0, 16.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLine(float x, float y) {
        GuiWidgets.bind();
        RenderUtil.drawTexturedModalRect(x, y, 0.0, 8.0, 8.0, 1.0);
    }

    public static void drawSquare(float x, float y, float red, float green, float blue) {
        GuiWidgets.drawSquare(x, y, red, green, blue, 1.0f);
    }

    public static void drawSquare(float x, float y, float red, float green, float blue, float alpha) {
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
        GuiWidgets.drawSquare(x, y);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSquare(float x, float y) {
        GuiWidgets.bind();
        RenderUtil.drawTexturedModalRect(x, y, 0.0, 0.0, 8.0, 8.0);
    }

    public static void drawEnergy(float x, float y, float w, float h) {
        GuiWidgets.drawEnergy(x, y, w, h, true);
    }

    public static void drawEnergy(float x, float y, float w, float h, boolean animate) {
        GuiWidgets.drawEnergy(x, y, w, h, animate ? (x > y ? EnumPowerAnimation.RIGHT : EnumPowerAnimation.UP) : EnumPowerAnimation.NONE);
    }

    public static void drawEnergy(float x, float y, float w, float h, EnumPowerAnimation animate) {
        int cx;
        GuiWidgets.bind();
        float time = (float)(System.currentTimeMillis() % 1500L) / 1500.0f;
        float animX = Math.abs(time * (float)animate.x) * 8.0f;
        float animY = Math.abs(time * (float)animate.y) * 8.0f;
        if (animate.x < 0) {
            animX = 8.0f - animX;
        }
        if (animate.y < 0) {
            animY = 8.0f - animY;
        }
        int fullX = (int)Math.floor(w / 8.0f);
        int fullY = (int)Math.floor(h / 8.0f);
        float leftX = w % 8.0f;
        float leftY = h % 8.0f;
        if (fullX >= 0) {
            for (int cy = 0; cy < fullY || cy == 0 && fullY == 0; ++cy) {
                RenderUtil.drawTexturedModalRect(x + (float)(fullX * 8), y + (float)(cy * 8), 8.0f + animX, animY, leftX, 8.0);
            }
        }
        if (fullY >= 0) {
            for (cx = 0; cx < fullX || cx == 0 && fullX == 0; ++cx) {
                RenderUtil.drawTexturedModalRect(x + (float)(cx * 8), y + (float)(fullY * 8), 8.0f + animX, animY, 8.0, leftY);
            }
        }
        if (fullX > 0 && fullY > 0) {
            RenderUtil.drawTexturedModalRect(x + (float)(fullX * 8), y + (float)(fullY * 8), 8.0f + animX, animY, leftX, leftY);
        }
        for (cx = 0; cx < fullX; ++cx) {
            for (int cy = 0; cy < fullY; ++cy) {
                RenderUtil.drawTexturedModalRect(x + (float)(cx * 8), y + (float)(cy * 8), 8.0f + animX, animY, 8.0, 8.0);
            }
        }
    }

    public static void bind() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
    }

    public static GuiTexBakery bakeTexture(GuiContainer gui) {
        GuiTexBakery b = GuiTexBakery.start();
        b.body(0, 0, gui.getXSize(), gui.getYSize());
        for (Slot s : gui.field_147002_h.field_75151_b) {
            b.slot(s.field_75223_e - 1, s.field_75221_f - 1);
        }
        return b;
    }

    public static enum EnumPowerAnimation {
        UP(0, 1),
        DOWN(0, -1),
        LEFT(1, 0),
        RIGHT(-1, 0),
        RIGHT_UP(-1, 1),
        LEFT_DOWN(1, -1),
        NONE(0, 0);

        public final int x;
        public final int y;

        private EnumPowerAnimation(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

