/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.bookAPI.fancy;

import com.zeitheron.hammercore.bookAPI.fancy.HCFontRenderer;
import com.zeitheron.hammercore.bookAPI.fancy.IManualPageRender;
import com.zeitheron.hammercore.utils.InterItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ManualPage {
    public PageType type = PageType.TEXT;
    public String text;
    public String research;
    public ResourceLocation image;
    private Object recipe;
    public ItemStack recipeOutput;
    public final List<ItemStack> allOutputs = new ArrayList<ItemStack>();

    public static List<IRecipe> findRecipesFor(ItemStack out) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        CraftingManager.field_193380_a.forEach(recipe -> {
            if (recipe.func_77571_b().func_77969_a(out)) {
                recipes.add((IRecipe)recipe);
            }
        });
        return recipes;
    }

    @SideOnly(value=Side.CLIENT)
    public void addPage(HCFontRenderer fr, int maxWidth, int maxHeight, List<ManualPage> pages) {
        pages.add(this);
    }

    public Object getRecipe() {
        if (this.type == PageType.NORMAL_CRAFTING) {
            if (this.recipe instanceof ItemStack[]) {
                ArrayList<IRecipe> rs = new ArrayList<IRecipe>();
                for (ItemStack r : (ItemStack[])this.recipe) {
                    rs.addAll(ManualPage.findRecipesFor(r));
                }
                return rs.toArray(new IRecipe[0]);
            }
            if (this.recipe instanceof ItemStack) {
                return ManualPage.findRecipesFor((ItemStack)this.recipe).toArray(new IRecipe[0]);
            }
        }
        if (this.type == PageType.SMELTING && InterItemStack.isStackNull(this.recipeOutput) && this.recipe instanceof ItemStack) {
            this.recipeOutput = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.recipe);
        }
        return this.recipe;
    }

    public ManualPage setRecipe(Object recipe) {
        this.recipe = recipe;
        return this;
    }

    public ManualPage(Object recipe, PageType page) {
        this.type = page;
        this.recipe = recipe;
    }

    public ManualPage(String text) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = null;
        this.type = PageType.TEXT;
        this.text = text;
    }

    public ManualPage(String text, ItemStack output) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = output.func_77946_l();
        this.allOutputs.add(output.func_77946_l());
        this.type = PageType.TEXT;
        this.text = text;
    }

    public ManualPage(String research, String text) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = null;
        this.type = PageType.TEXT_CONCEALED;
        this.research = research;
        this.text = text;
    }

    public ManualPage(List recipe) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = null;
        this.type = PageType.COMPOUND_CRAFTING;
        this.recipe = recipe;
    }

    public ManualPage(ItemStack input) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = null;
        this.type = PageType.SMELTING;
        this.recipe = input;
        this.recipeOutput = FurnaceRecipes.func_77602_a().func_151395_a(input).func_77946_l();
    }

    public ManualPage(ResourceLocation image, String caption) {
        this.text = null;
        this.research = null;
        this.image = null;
        this.recipe = null;
        this.recipeOutput = null;
        this.type = PageType.IMAGE;
        this.image = image;
        this.text = caption;
    }

    public ManualPage(PageType type, ItemStack item) {
        if (type == PageType.NORMAL_CRAFTING) {
            this.text = null;
            this.research = null;
            this.image = null;
            this.type = type;
            this.recipe = item;
            this.allOutputs.add(item.func_77946_l());
            this.recipeOutput = item;
        } else if (type == PageType.SMELTING) {
            this.text = null;
            this.research = null;
            this.image = null;
            this.recipe = null;
            this.recipeOutput = null;
            this.type = type;
            this.recipe = item;
            this.recipeOutput = FurnaceRecipes.func_77602_a().func_151395_a(item).func_77946_l();
            this.allOutputs.add(this.recipeOutput.func_77946_l());
        }
    }

    public ManualPage addClickthroughAssociation(ItemStack ... associations) {
        for (ItemStack a : associations) {
            this.allOutputs.add(a);
        }
        return this;
    }

    public String getTranslatedText() {
        String ret = "";
        if (this.text != null && (ret = I18n.func_135052_a((String)this.text, (Object[])new Object[0])).isEmpty()) {
            ret = this.text;
        }
        return ret;
    }

    public static class PageType {
        public static final PageType TEXT = new PageType("TEXT");
        public static final PageType TEXT_CONCEALED = new PageType("TEXT_CONCEALED");
        public static final PageType IMAGE = new PageType("IMAGE");
        public static final PageType NORMAL_CRAFTING = new PageType("NORMAL_CRAFTING");
        public static final PageType COMPOUND_CRAFTING = new PageType("COMPOUND_CRAFTING");
        public static final PageType SMELTING = new PageType("SMELTING");
        private final String v1;
        private Object render;
        private final String renderClass;

        private PageType(String var1) {
            this(var1, null);
        }

        public PageType(String var1, String renderClass) {
            this.v1 = var1;
            this.renderClass = renderClass;
        }

        public String getV1() {
            return this.v1;
        }

        @SideOnly(value=Side.CLIENT)
        public IManualPageRender getRender() {
            if (this.renderClass == null || this.renderClass.isEmpty()) {
                return null;
            }
            if (this.render == null) {
                try {
                    this.render = Class.forName(this.renderClass).newInstance();
                }
                catch (Throwable err) {
                    System.err.println("Unable to construct IManualPageRender");
                    err.printStackTrace();
                    this.render = new Object();
                }
            }
            return (IManualPageRender)this.render;
        }
    }
}

