/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.lighting;

import com.zeitheron.hammercore.api.lighting.ColoredLightManager;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.gl.shading.ShaderVar;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ShaderLightingVariable
extends ShaderVar<Integer> {
    private int blockLimit;
    private final String lightStructName;

    public ShaderLightingVariable(String key) {
        this(key, "Light");
    }

    public ShaderLightingVariable(String key, String lightStructName) {
        super(key);
        this.lightStructName = lightStructName;
        RenderUtil.glTaskAsync(() -> {
            this.blockLimit = GL11.glGetInteger((int)35376) / 8 / 4;
            return this.blockLimit;
        });
    }

    @Override
    protected Integer getState() {
        int lightCount = ColoredLightManager.UNIFORM_LIGHT_COUNT.getAsInt();
        return (int)Math.ceil((float)lightCount / (float)this.blockLimit);
    }

    @Override
    protected String compute(Integer blocks) {
        int i;
        String layoutTemplate = String.format("layout(std140) uniform lightBuffer%%s\n{\n  %s lights%%s[%d];\n};\n\n", this.lightStructName, this.blockLimit);
        StringBuilder gen = new StringBuilder();
        for (i = 0; i < blocks; ++i) {
            String s = Integer.toString(i);
            gen.append(String.format(layoutTemplate, s, s));
        }
        gen.append("\n").append(this.lightStructName).append(" getLight(int idx)\n{");
        for (i = 0; i < blocks; ++i) {
            int start = this.blockLimit * i;
            int end = this.blockLimit * (i + 1);
            gen.append(String.format("\n  %sif(idx >= %d && idx < %d) return lights%d[idx - %d];", i > 0 ? "else " : "", start, end, i, start));
        }
        gen.append("\n  return lights0[0];");
        gen.append("\n}");
        return gen.toString();
    }
}

