/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.lighting;

import com.zeitheron.hammercore.client.utils.gl.IGLBufferStream;
import com.zeitheron.hammercore.client.utils.gl.IGLWritable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ColoredLight
implements IGLWritable {
    public static final int FLOAT_SIZE = 8;
    public float x;
    public float y;
    public float z;
    public float r;
    public float g;
    public float b;
    public float a;
    public float radius;

    public ColoredLight(float x, float y, float z, float r, float g, float b, float a, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.radius = radius;
    }

    public ColoredLight reposition(Entity entity, float partialTicks) {
        this.x = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks);
        this.y = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks);
        this.z = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks);
        return this;
    }

    public ColoredLight copy() {
        return new ColoredLight(this.x, this.y, this.z, this.r, this.g, this.b, this.a, this.radius);
    }

    @Override
    public int getFloatSize() {
        return 8;
    }

    @Override
    public void writeFloats(IGLBufferStream<Float> stream) {
        stream.putAll((Float[])new Float[]{Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a)});
        stream.putAll((Float[])new Float[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)});
        stream.put(Float.valueOf(this.radius));
    }

    public Builder toBuilder() {
        return ColoredLight.builder().pos(this.x, this.y, this.z).color(this.r, this.g, this.b, this.a).radius(this.radius);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float x = Float.NaN;
        private float y = Float.NaN;
        private float z = Float.NaN;
        private float r = Float.NaN;
        private float g = Float.NaN;
        private float b = Float.NaN;
        private float a = Float.NaN;
        private float radius = Float.NaN;

        public Builder pos(BlockPos pos) {
            return this.pos((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        }

        public Builder pos(Vec3d pos) {
            return this.pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }

        public Builder pos(Entity e) {
            return this.pos(e.field_70165_t + (double)(e.field_70130_N / 2.0f), e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v + (double)(e.field_70130_N / 2.0f));
        }

        public Builder pos(Entity entity, float partialTicks) {
            float x = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks);
            float y = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks);
            float z = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks);
            return this.pos(x + entity.field_70130_N / 2.0f, y + entity.field_70131_O / 2.0f, z + entity.field_70130_N / 2.0f);
        }

        public Builder pos(double x, double y, double z) {
            return this.pos((float)x, (float)y, (float)z);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder color(Vec3d c, float alpha) {
            return this.color((float)c.field_72450_a, (float)c.field_72448_b, (float)c.field_72449_c, alpha);
        }

        public Builder color(Vec3d c) {
            return this.color((float)c.field_72450_a, (float)c.field_72448_b, (float)c.field_72449_c, 1.0f);
        }

        public Builder color(int c, boolean hasAlpha) {
            return this.color(this.extract(c, 2), this.extract(c, 1), this.extract(c, 0), hasAlpha ? this.extract(c, 3) : 1.0f);
        }

        private float extract(int i, int idx) {
            return (float)(i >> idx * 8 & 0xFF) / 255.0f;
        }

        public Builder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public Builder color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder alpha(int alpha) {
            return this.alpha((float)alpha / 255.0f);
        }

        public Builder alpha(float alpha) {
            this.a = alpha;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public ColoredLight build() {
            if (Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z) && Float.isFinite(this.r) && Float.isFinite(this.g) && Float.isFinite(this.b) && Float.isFinite(this.a) && Float.isFinite(this.radius)) {
                return new ColoredLight(this.x, this.y, this.z, this.r, this.g, this.b, this.a, this.radius);
            }
            throw new IllegalArgumentException("Position, color, and radius must be set, and cannot be infinite");
        }
    }
}

