/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.io.serializers;

import com.zeitheron.hammercore.api.io.serializers.INBTSerializer;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NumberSerializer<N extends Number, NBT extends NBTBase>
implements INBTSerializer<N> {
    final int nbtType;
    final Function<N, NBT> encode;
    final Function<NBT, N> decode;

    public NumberSerializer(int nbtType, Function<N, NBT> encode, Function<NBT, N> decode) {
        this.nbtType = nbtType;
        this.encode = encode;
        this.decode = decode;
    }

    @Override
    public void serialize(NBTTagCompound nbt, String key, @Nonnull N value) {
        if (value != null) {
            nbt.func_74782_a(key, (NBTBase)this.encode.apply(value));
        }
    }

    @Override
    public N deserialize(NBTTagCompound nbt, String key) {
        if (nbt.func_150297_b(key, this.nbtType)) {
            return (N)((Number)this.decode.apply(Cast.cast(nbt.func_74781_a(key))));
        }
        return null;
    }
}

