/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.io.serializers;

import com.zeitheron.hammercore.api.io.serializers.INBTSerializer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class EnumNBTSerializer<ET extends Enum<ET>>
implements INBTSerializer<ET> {
    final Class<ET> type;
    final ET[] constants;

    public EnumNBTSerializer(Class<ET> type) {
        this.type = type;
        this.constants = (Enum[])type.getEnumConstants();
    }

    @Override
    public void serialize(NBTTagCompound nbt, String key, @Nonnull ET value) {
        if (value != null) {
            nbt.func_74768_a(key, ((Enum)value).ordinal());
        }
    }

    @Override
    public ET deserialize(NBTTagCompound nbt, String key) {
        if (nbt.func_150297_b(key, 3)) {
            return this.constants[Math.abs(nbt.func_74762_e(key)) % this.constants.length];
        }
        return null;
    }
}

