/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zeitheron.hammercore.api.io.NBTSerializable;
import com.zeitheron.hammercore.api.io.NBTSerializer;
import com.zeitheron.hammercore.api.io.serializers.BooleanSerializer;
import com.zeitheron.hammercore.api.io.serializers.EnumNBTSerializer;
import com.zeitheron.hammercore.api.io.serializers.INBTSerializer;
import com.zeitheron.hammercore.api.io.serializers.NumberSerializer;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class NBTSerializationHelper {
    public static final Logger LOG = LogManager.getLogger((String)"HammerLib");
    private static final BiMap<Class<?>, INBTSerializer<?>> SERIALIZER_MAP = HashBiMap.create();
    private static final BiMap<Class<?>, INBTSerializer<?>> ENUM_SERIALIZER_MAP = HashBiMap.create();

    public static <T extends Enum<T>> INBTSerializer<T> forEnum(Class<T> type) {
        return (INBTSerializer)Cast.cast(ENUM_SERIALIZER_MAP.computeIfAbsent(type, t -> new EnumNBTSerializer(type)));
    }

    public static <T> void registerSerializer(Class<T> type, INBTSerializer<T> serializer) {
        SERIALIZER_MAP.putIfAbsent(type, serializer);
    }

    public static void construct(ASMDataTable table) {
        NBTSerializationHelper.registerSerializer(Boolean.class, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.class, new NumberSerializer<Byte, NBTTagByte>(1, NBTTagByte::new, NBTTagByte::func_150290_f));
        NBTSerializationHelper.registerSerializer(Short.class, new NumberSerializer<Short, NBTTagShort>(2, NBTTagShort::new, NBTTagShort::func_150289_e));
        NBTSerializationHelper.registerSerializer(Float.class, new NumberSerializer<Float, NBTTagFloat>(5, NBTTagFloat::new, NBTTagFloat::func_150288_h));
        NBTSerializationHelper.registerSerializer(Double.class, new NumberSerializer<Double, NBTTagDouble>(6, NBTTagDouble::new, NBTTagDouble::func_150286_g));
        NBTSerializationHelper.registerSerializer(Integer.class, new NumberSerializer<Integer, NBTTagInt>(3, NBTTagInt::new, NBTTagInt::func_150287_d));
        NBTSerializationHelper.registerSerializer(Long.class, new NumberSerializer<Long, NBTTagLong>(4, NBTTagLong::new, NBTTagLong::func_150291_c));
        NBTSerializationHelper.registerSerializer(Boolean.TYPE, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.TYPE, new NumberSerializer<Byte, NBTTagByte>(1, NBTTagByte::new, NBTTagByte::func_150290_f));
        NBTSerializationHelper.registerSerializer(Short.TYPE, new NumberSerializer<Short, NBTTagShort>(2, NBTTagShort::new, NBTTagShort::func_150289_e));
        NBTSerializationHelper.registerSerializer(Float.TYPE, new NumberSerializer<Float, NBTTagFloat>(5, NBTTagFloat::new, NBTTagFloat::func_150288_h));
        NBTSerializationHelper.registerSerializer(Double.TYPE, new NumberSerializer<Double, NBTTagDouble>(6, NBTTagDouble::new, NBTTagDouble::func_150286_g));
        NBTSerializationHelper.registerSerializer(Integer.TYPE, new NumberSerializer<Integer, NBTTagInt>(3, NBTTagInt::new, NBTTagInt::func_150287_d));
        NBTSerializationHelper.registerSerializer(Long.TYPE, new NumberSerializer<Long, NBTTagLong>(4, NBTTagLong::new, NBTTagLong::func_150291_c));
        NBTSerializationHelper.registerSerializer(BigInteger.class, new NumberSerializer<BigInteger, NBTTagByteArray>(7, b -> new NBTTagByteArray(b.toByteArray()), nbt -> new BigInteger(nbt.func_150292_c())));
        NBTSerializationHelper.registerSerializer(BigDecimal.class, new NumberSerializer<BigDecimal, NBTTagByteArray>(7, b -> new NBTTagByteArray(b.toString().getBytes(StandardCharsets.UTF_8)), nbt -> new BigDecimal(new String(nbt.func_150292_c(), StandardCharsets.UTF_8))));
        for (ASMDataTable.ASMData dat : table.getAll(NBTSerializer.class.getCanonicalName())) {
            try {
                List types = (List)Cast.cast(dat.getAnnotationInfo().get("value"));
                Constructor<?> ctor = Class.forName(dat.getClassName()).getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                INBTSerializer ser = (INBTSerializer)Cast.cast(ctor.newInstance(new Object[0]));
                for (Type type : types) {
                    Class<?> c = ReflectionUtil.fetchClassAny(type);
                    if (c != null) {
                        SERIALIZER_MAP.putIfAbsent(c, (Object)ser);
                        LOG.debug("Registered NBT serializer for type " + c + ": " + ser);
                        continue;
                    }
                    LOG.error("Unable to find class " + type.getInternalName() + "!");
                }
            }
            catch (ReflectiveOperationException roe) {
                LOG.error("Failed to create an instance of " + dat.getClassName(), (Throwable)roe);
            }
        }
    }

    public static void serializeField(Class<?> type, Object instance, NBTTagCompound nbt, String key) {
        if (instance == null) {
            return;
        }
        INBTSerializer serializer = type.isEnum() ? NBTSerializationHelper.forEnum((Class)Cast.cast(type)) : (INBTSerializer)SERIALIZER_MAP.get(type);
        if (serializer != null) {
            serializer.serialize(nbt, key, Cast.cast(instance));
        } else if (type.isArray()) {
            NBTTagCompound lst = new NBTTagCompound();
            Class<?> compType = type.getComponentType();
            int length = Array.getLength(instance);
            for (int i = 0; i < length; ++i) {
                Object component = Array.get(instance, i);
                NBTSerializationHelper.serializeField(compType, component, lst, Integer.toString(i));
            }
            nbt.func_74782_a(key, (NBTBase)lst);
        } else {
            LOG.warn("Don't know how to serialize " + type + " " + key + " in " + type);
        }
    }

    public static Object deserializeField(Class<?> type, NBTTagCompound nbt, String key) {
        INBTSerializer serializer = type.isEnum() ? NBTSerializationHelper.forEnum((Class)Cast.cast(type)) : (INBTSerializer)SERIALIZER_MAP.get(type);
        if (serializer != null) {
            return serializer.deserialize(nbt, key);
        }
        if (type.isArray()) {
            if (nbt.func_150297_b(key, 10)) {
                NBTTagCompound lst = nbt.func_74775_l(key);
                Class<?> compType = type.getComponentType();
                int length = lst.func_150296_c().size();
                Object instance = Array.newInstance(compType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, NBTSerializationHelper.deserializeField(compType, lst, Integer.toString(i)));
                }
                return instance;
            }
            return null;
        }
        LOG.warn("Don't know how to deserialize " + type + " " + key + " in " + type);
        return null;
    }

    public static NBTTagCompound serialize(Object instance) {
        Class<?> type = instance.getClass();
        NBTTagCompound nbt = new NBTTagCompound();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    Object inst = field.get(instance);
                    if (inst instanceof INBTSerializable) {
                        INBTSerializable s = (INBTSerializable)inst;
                        nbt.func_74782_a(name, s.serializeNBT());
                        continue;
                    }
                    if (INBTSerializer.class.isAssignableFrom(field.getType())) continue;
                    LOG.warn("Don't know how to serialize " + field + " in " + type);
                    continue;
                }
                NBTSerializationHelper.serializeField(field.getType(), field.get(instance), nbt, name);
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Failed to serialize field " + field + " in " + type, (Throwable)e);
            }
        }
        return nbt;
    }

    public static void deserialize(Object instance, NBTTagCompound nbt) {
        Class<?> type = instance.getClass();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    Object inst = field.get(instance);
                    if (inst instanceof INBTSerializable) {
                        NBTBase tag = nbt.func_74781_a(name);
                        if (tag == null) continue;
                        ((INBTSerializable)inst).deserializeNBT(tag);
                        continue;
                    }
                    if (INBTSerializer.class.isAssignableFrom(field.getType())) {
                        if (!nbt.func_74764_b(name)) continue;
                        LOG.warn("Can't deserialize " + field + " in " + type + " since the final value is null. Trying to deserialize tag: " + nbt.func_74781_a(name));
                        continue;
                    }
                    LOG.warn("Don't know how to deserialize " + field + " in " + type);
                    continue;
                }
                Object val = NBTSerializationHelper.deserializeField(field.getType(), nbt, name);
                if (val == null && field.getType().isPrimitive()) continue;
                field.set(instance, val);
            }
            catch (Throwable e) {
                LOG.error("Failed to deserialize field " + field + " in " + type, e);
            }
        }
    }
}

