/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.inconnect;

import com.zeitheron.hammercore.utils.PositionedStateImplementation;
import java.util.function.BiFunction;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class InConnectAPI {
    public static final BiFunction<IBlockAccess, Pair<BlockPos, IBlockState>, IBlockState> extendedState = (world, p) -> {
        BlockPos pos = (BlockPos)p.getKey();
        IBlockState state = (IBlockState)p.getValue();
        if (state instanceof BlockStateContainer.StateImplementation) {
            return PositionedStateImplementation.convert((BlockStateContainer.StateImplementation)state).withPos(pos, (IBlockAccess)world);
        }
        return (IBlockState)p.getValue();
    };

    public static IBlockState makeExtendedPositionedState(IBlockAccess world, BlockPos pos, IBlockState state) {
        return extendedState.apply(world, (Pair<BlockPos, IBlockState>)Pair.of((Object)pos, (Object)state));
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSpritePartial partial(TextureAtlasSprite sprite, float subX, float subY, float subWidth, float subHeight) {
        TextureAtlasSpritePartial partial = new TextureAtlasSpritePartial(sprite.func_94215_i(), subX, subY, subWidth, subHeight);
        partial.func_94217_a(sprite);
        return partial;
    }

    @SideOnly(value=Side.CLIENT)
    public static class TextureAtlasSpritePartial
    extends TextureAtlasSprite
    implements IPartialSprite {
        float sx;
        float sy;
        float sw;
        float sh;

        public TextureAtlasSpritePartial(String spriteName, float subX, float subY, float subWidth, float subHeight) {
            super(spriteName);
            this.sx = subX;
            this.sy = subY;
            this.sw = subWidth;
            this.sh = subHeight;
        }

        public float func_94209_e() {
            float d = super.func_94212_f() - super.func_94209_e();
            return super.func_94209_e() + d * this.sx;
        }

        public float func_94206_g() {
            float d = super.func_94210_h() - super.func_94206_g();
            return super.func_94206_g() + d * this.sy;
        }

        public float func_94212_f() {
            float d = super.func_94212_f() - super.func_94209_e();
            return this.func_94209_e() + d * this.sw;
        }

        public float func_94210_h() {
            float d = super.func_94210_h() - super.func_94206_g();
            return this.func_94206_g() + d * this.sh;
        }

        public float func_94214_a(double u) {
            float f = this.func_94212_f() - this.func_94209_e();
            return this.func_94209_e() + f * (float)u / 16.0f;
        }

        public float func_94207_b(double v) {
            float f = this.func_94210_h() - this.func_94206_g();
            return this.func_94206_g() + f * (float)v / 16.0f;
        }
    }

    public static interface IPartialSprite {
    }
}

