/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.inconnect;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.api.blocks.INoBlockstate;
import com.zeitheron.hammercore.api.inconnect.EnumConnTexVersion;
import com.zeitheron.hammercore.api.inconnect.InConnectAPI;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBlockConnectable
extends INoBlockstate {
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTxMap();

    default public ResourceLocation getTx(int layer, @Nullable IBlockAccess world, BlockPos pos) {
        return layer == 0 ? this.getTxMap() : (layer == 1 ? new ResourceLocation(this.getTxMap().func_110624_b(), this.getTxMap().func_110623_a() + "2") : null);
    }

    default public Stream<ResourceLocation> getSprites() {
        Stream.Builder<ResourceLocation> builder = Stream.builder();
        int ls = this.getConnectTextureVersion().getLayers();
        for (int i = 0; i < ls; ++i) {
            builder.add(this.getTx(i, null, BlockPos.field_177992_a));
        }
        return builder.build().filter(Predicates.notNull());
    }

    @SideOnly(value=Side.CLIENT)
    default public TextureAtlasSprite getParticleTexture(IBlockState state) {
        EnumConnTexVersion ctv = this.getConnectTextureVersion();
        if (ctv == EnumConnTexVersion.V1) {
            TextureAtlasSprite sprite = IBlockConnectable.getSprite(Objects.toString(this.getTx(0, null, BlockPos.field_177992_a)));
            return InConnectAPI.partial(sprite, 0.375f, 0.375f, 0.25f, 0.25f);
        }
        if (ctv == EnumConnTexVersion.V2) {
            TextureAtlasSprite sprite = IBlockConnectable.getSprite(Objects.toString(this.getTx(0, null, BlockPos.field_177992_a)));
            return InConnectAPI.partial(sprite, 0.0f, 0.0f, 0.25f, 0.25f);
        }
        if (ctv == EnumConnTexVersion.V3) {
            TextureAtlasSprite sprite = IBlockConnectable.getSprite(Objects.toString(this.getTx(0, null, BlockPos.field_177992_a)));
            return InConnectAPI.partial(sprite, 0.25f, 0.5f, 0.25f, 0.25f);
        }
        return null;
    }

    public AxisAlignedBB getBlockShape(IBlockAccess var1, BlockPos var2, IBlockState var3);

    default public EnumConnTexVersion getConnectTextureVersion() {
        return EnumConnTexVersion.V1;
    }

    @SideOnly(value=Side.CLIENT)
    default public TextureAtlasSprite getSpriteForFace(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing face, long rand, int layer) {
        return IBlockConnectable.getSprite(this.getTx(layer, world, pos).toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(String path) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(path);
    }
}

