/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api;

import com.zeitheron.hammercore.api.APILoader;
import com.zeitheron.hammercore.event.GetAllRequiredApisEvent;
import java.util.HashMap;
import java.util.Map;

public class RequiredDeps {
    private static final Map<String, String> REQUESTED_DEPS = new HashMap<String, String>();

    public static void addRequests(GetAllRequiredApisEvent evt) {
        REQUESTED_DEPS.putAll(evt.NDEP);
    }

    public static void addRequest(String api, String version) {
        REQUESTED_DEPS.put(api, "=" + version);
    }

    public static void addRequest(String api) {
        REQUESTED_DEPS.put(api, "~");
    }

    public static boolean allDepsResolved() {
        for (String api : REQUESTED_DEPS.keySet()) {
            boolean resolved;
            String version = REQUESTED_DEPS.get(api);
            if (version != null) {
                if (version.equals("~")) {
                    version = null;
                } else if (version.startsWith("=")) {
                    version = version.substring(1);
                }
            }
            if (resolved = version != null ? APILoader.isApiLoaded(api, version) : APILoader.isApiLoaded(api)) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getAllMissingDeps() {
        HashMap<String, String> MISSINGS = new HashMap<String, String>();
        for (String api : REQUESTED_DEPS.keySet()) {
            boolean resolved;
            String version = REQUESTED_DEPS.get(api);
            if (version != null) {
                if (version.equals("~")) {
                    version = null;
                } else if (version.startsWith("=")) {
                    version = version.substring(1);
                }
            }
            if (resolved = version != null ? APILoader.isApiLoaded(api, version) : APILoader.isApiLoaded(api)) continue;
            MISSINGS.put(api, version);
        }
        return MISSINGS;
    }
}

