/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class GameRules {
    public static final Map<String, GameRuleEntry> entries = new HashMap<String, GameRuleEntry>();

    public static void registerGameRule(GameRuleEntry entry) {
        entries.put(entry.name, entry);
    }

    @Nonnull
    public static GameRuleEntry getEntry(String name) {
        return entries.getOrDefault(name, GameRuleEntry.NIL);
    }

    public static void load(MinecraftServer server) {
    }

    public static void cleanup() {
    }

    public static enum ValueType {
        STRING_VALUE(0),
        BOOLEAN_VALUE(1),
        INT_VALUE(2),
        DECIMAL_VALUE(0);

        final int ord;

        private ValueType(int ord) {
            this.ord = ord;
        }

        public GameRules.ValueType toNM() {
            return GameRules.ValueType.values()[this.ord];
        }
    }

    public static class GameRuleEntry {
        private static final GameRuleEntry NIL = new GameRuleEntry("unknown", "", "gamerules.hc_unknown", ValueType.STRING_VALUE);
        public final String name;
        public final String i18nDesc;
        public final Object defVal;
        public final ValueType type;

        public GameRuleEntry(String name, Object defValue, String i18nDesc, ValueType type) {
            this.i18nDesc = i18nDesc;
            this.name = name;
            this.defVal = defValue;
            this.type = type;
        }

        public String getValue(World world) {
            if (this == NIL) {
                return "";
            }
            if (!world.func_82736_K().func_82765_e(this.name)) {
                return (String)this.defVal;
            }
            return world.func_82736_K().func_82767_a(this.name);
        }

        public int getInt(World world) {
            if (this == NIL) {
                return 0;
            }
            if (this.type != ValueType.INT_VALUE) {
                return 0;
            }
            if (!world.func_82736_K().func_82765_e(this.name)) {
                return (Integer)this.defVal;
            }
            return world.func_82736_K().func_180263_c(this.name);
        }

        public boolean getBool(World world) {
            if (this == NIL) {
                return false;
            }
            if (this.type != ValueType.BOOLEAN_VALUE) {
                return false;
            }
            if (!world.func_82736_K().func_82765_e(this.name)) {
                return (Boolean)this.defVal;
            }
            return world.func_82736_K().func_82766_b(this.name);
        }

        public double getDouble(World world) {
            if (this == NIL) {
                return 0.0;
            }
            if (this.type != ValueType.DECIMAL_VALUE) {
                return 0.0;
            }
            if (!world.func_82736_K().func_82765_e(this.name)) {
                return ((Number)this.defVal).doubleValue();
            }
            try {
                return Double.parseDouble(this.getValue(world));
            }
            catch (Throwable throwable) {
                return 0.0;
            }
        }

        public float getFloat(World world) {
            if (this == NIL) {
                return 0.0f;
            }
            if (this.type != ValueType.DECIMAL_VALUE && !this.name.equals("hc_falldamagemult")) {
                return 0.0f;
            }
            if (!world.func_82736_K().func_82765_e(this.name)) {
                return ((Number)this.defVal).floatValue();
            }
            try {
                return Float.parseFloat(this.getValue(world));
            }
            catch (Throwable throwable) {
                return 0.0f;
            }
        }
    }
}

