/*
 * Decompiled with CFR 0.152.
 */
package portb.mod.uberconduitprobe.item;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.tool.IHideFacades;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.handler.KeyTracker;
import crazypants.enderio.conduits.conduit.BlockConduitBundle;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import org.lwjgl.input.Keyboard;
import portb.mod.uberconduitprobe.util.UberProbeConfig;
import portb.mod.uberconduitprobe.util.VectorHelper;

public class UberProbeItem
extends Item
implements IHideFacades {
    public static final String REGISTRY_NAME = "uber_conduit_probe_item";
    private static final String NBT_FIRST_POS_KEY = "first_pos";
    private static final String NBT_SECOND_POS_KEY = "second_pos";
    private static final String NBT_CONDUIT_DATA_KEY = "conduit_data";
    private static final String NBT_CONDUIT_DIRECTION_KEY = "direction";
    private static final String NBT_SELECTING_KEY = "is_selecting";
    private static final Logger logger = Logger.getLogger("UberProbeItem");

    private static int getMaxConfigurationVolume() {
        return UberProbeConfig.MaxConfigurableVolume;
    }

    public UberProbeItem() {
        this.setRegistryName(new ResourceLocation("uberconduitprobe", REGISTRY_NAME));
        this.func_77655_b("uberconduitprobe.uber_conduit_probe_item");
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public static ItemMode getItemMode(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof UberProbeItem)) {
            throw new IllegalArgumentException("Cannot get mode for item " + stack.func_77973_b().getClass().getName());
        }
        if (stack.func_77973_b().getDamage(stack) == 0) {
            return ItemMode.COPY;
        }
        return ItemMode.PASTE;
    }

    public static boolean isSelecting(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(NBT_FIRST_POS_KEY);
    }

    public static BlockPos getFirstPosition(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            throw new IllegalArgumentException("Stack had no first_pos tag");
        }
        return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f(NBT_FIRST_POS_KEY));
    }

    public static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult lookingAt;
        if (!world.field_72995_K && (lookingAt = VectorHelper.getPlayerLookingAt(player)) == null) {
            this.resetSelectedArea(player);
            player.func_145747_a((ITextComponent)new TextComponentString("Reset selected area"));
        }
        return super.func_77659_a(world, player, hand);
    }

    private void resetSelectedArea(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            NBTTagCompound newTag = new NBTTagCompound();
            if (tag.func_74764_b(NBT_CONDUIT_DATA_KEY)) {
                newTag.func_74782_a(NBT_CONDUIT_DATA_KEY, tag.func_74781_a(NBT_CONDUIT_DATA_KEY));
            }
            if (tag.func_74764_b(NBT_CONDUIT_DIRECTION_KEY)) {
                newTag.func_74782_a(NBT_CONDUIT_DIRECTION_KEY, tag.func_74781_a(NBT_CONDUIT_DIRECTION_KEY));
            }
            stack.func_77982_d(newTag);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184614_ca();
            ItemMode mode = UberProbeItem.getItemMode(stack);
            if (mode == ItemMode.COPY) {
                return this.copySettings(player, world, pos);
            }
            return this.pasteSettings(player, world, pos, side);
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult copySettings(EntityPlayer player, World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (block instanceof BlockConduitBundle && tileEntity != null) {
            BlockConduitBundle bundle = (BlockConduitBundle)block;
            RaytraceResult result = bundle.doRayTrace(world, pos, player);
            CollidableComponent component = result.component;
            if (!component.isCore()) {
                ItemStack itemStack = player.func_184614_ca();
                NBTTagCompound tag = new NBTTagCompound();
                if (!(itemStack.func_77973_b() instanceof UberProbeItem)) {
                    throw new IllegalStateException("Handler was triggered for item that is not UberProbeItem");
                }
                for (IServerConduit conduit : ((IConduitBundle)tileEntity).getServerConduits()) {
                    EnumFacing dir = component.getDirection();
                    if (!conduit.getExternalConnections().contains(dir)) continue;
                    conduit.writeConnectionSettingsToNBT(dir, tag);
                }
                if (itemStack.func_77978_p() == null) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound itemTag = itemStack.func_77978_p();
                itemTag.func_74782_a(NBT_CONDUIT_DATA_KEY, (NBTBase)tag);
                itemTag.func_74768_a(NBT_CONDUIT_DIRECTION_KEY, component.getDirection().func_176745_a());
                player.func_145747_a((ITextComponent)new TextComponentString("Copied conduit configuration"));
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private EnumActionResult pasteSettings(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        Style redStyle = new Style().func_150238_a(TextFormatting.RED);
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack.func_77978_p() == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("No conduit configuration is stored!"));
            itemStack.func_77982_d(new NBTTagCompound());
            return EnumActionResult.FAIL;
        }
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag.func_74764_b(NBT_CONDUIT_DATA_KEY) && tag.func_74764_b(NBT_CONDUIT_DIRECTION_KEY) && tag.func_74764_b(NBT_FIRST_POS_KEY)) {
            EnumFacing desiredDirection = EnumFacing.values()[tag.func_74762_e(NBT_CONDUIT_DIRECTION_KEY)];
            NBTTagCompound conduitData = tag.func_74775_l(NBT_CONDUIT_DATA_KEY);
            BlockPos firstPosition = BlockPos.func_177969_a((long)tag.func_74763_f(NBT_FIRST_POS_KEY));
            long volume = this.getVolumeBetweenPoints(firstPosition, pos);
            if (volume > (long)UberProbeItem.getMaxConfigurationVolume()) {
                player.func_145747_a(new TextComponentString("Could not configure a volume of " + volume + " blocks. The maximum allowable volume is " + UberProbeItem.getMaxConfigurationVolume() + " blocks.").func_150255_a(redStyle));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Configured from " + this.posToHumanFriendlyString(firstPosition) + " to " + this.posToHumanFriendlyString(pos)));
                this.configureConduitsInRange(firstPosition, pos, world, desiredDirection, conduitData);
                this.resetSelectedArea(player);
            }
        } else {
            if (!tag.func_74764_b(NBT_CONDUIT_DATA_KEY) || !tag.func_74764_b(NBT_CONDUIT_DIRECTION_KEY)) {
                player.func_145747_a(new TextComponentString("No conduit configuration is stored!").func_150255_a(redStyle));
                return EnumActionResult.FAIL;
            }
            itemStack.func_77978_p().func_74772_a(NBT_FIRST_POS_KEY, pos.func_177986_g());
            player.func_145747_a((ITextComponent)new TextComponentString("Configuring from " + this.posToHumanFriendlyString(pos)));
        }
        return EnumActionResult.SUCCESS;
    }

    private void configureConduitsInRange(BlockPos firstPosition, BlockPos secondPosition, World world, EnumFacing desiredDirection, NBTTagCompound conduitData) {
        for (int x = Math.min(secondPosition.func_177958_n(), firstPosition.func_177958_n()); x <= Math.max(secondPosition.func_177958_n(), firstPosition.func_177958_n()); ++x) {
            for (int y = Math.min(secondPosition.func_177956_o(), firstPosition.func_177956_o()); y <= Math.max(secondPosition.func_177956_o(), firstPosition.func_177956_o()); ++y) {
                for (int z = Math.min(secondPosition.func_177952_p(), firstPosition.func_177952_p()); z <= Math.max(secondPosition.func_177952_p(), firstPosition.func_177952_p()); ++z) {
                    BlockPos breakPos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(breakPos);
                    Block block = blockState.func_177230_c();
                    TileEntity tileEntity = world.func_175625_s(breakPos);
                    if (!(block instanceof BlockConduitBundle) || !(tileEntity instanceof IConduitBundle)) continue;
                    for (IServerConduit conduit : ((IConduitBundle)tileEntity).getServerConduits()) {
                        conduit.readConduitSettingsFromNBT(desiredDirection, conduitData);
                    }
                }
            }
        }
    }

    private long getVolumeBetweenPoints(BlockPos a, BlockPos b) {
        int dx = Math.abs(Math.max(a.func_177958_n(), b.func_177958_n()) - Math.min(a.func_177958_n(), b.func_177958_n()));
        int dy = Math.abs(Math.max(a.func_177956_o(), b.func_177956_o()) - Math.min(a.func_177956_o(), b.func_177956_o()));
        int dz = Math.abs(Math.max(a.func_177952_p(), b.func_177952_p()) - Math.min(a.func_177952_p(), b.func_177952_p()));
        return (long)dx * (long)dy * (long)dz;
    }

    private String posToHumanFriendlyString(BlockPos pos) {
        return "(" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + ")";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!UberProbeItem.isShiftDown()) {
            SpecialTooltipHandler.addShowDetailsTooltip(tooltip);
        } else {
            tooltip.add("In copy mode, click on a conduit to copy its configuration.");
            tooltip.add("Note that only connections with the same direction as the copied connection will be affected by a paste.");
            tooltip.add("In paste mode, click to select 2 positions. All conduits with the same direction as the copied one will be configured.");
            tooltip.add("A box will show the selected area.");
            tooltip.add(Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName() + " in air to clear the selected area.");
            tooltip.add("Use Shift-Mouse wheel or '" + KeyTracker.yetawrenchmode.getBinding().getDisplayName() + "' to change mode");
        }
    }

    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "variant=copy"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "variant=paste"));
    }

    public boolean shouldHideFacades(@Nonnull ItemStack itemStack, @Nonnull EntityPlayer entityPlayer) {
        return true;
    }

    public static enum ItemMode {
        COPY,
        PASTE;

    }
}

