/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import com.google.common.collect.ArrayListMultimap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.MetalPress")
public class MetalPress {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, IItemStack mold, int energy, @Optional int inputSize) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        ItemStack sOut = CraftTweakerHelper.toStack(output);
        ItemStack sMold = CraftTweakerHelper.toStack(mold);
        if (!sOut.func_190926_b() && !sMold.func_190926_b()) {
            MetalPressRecipe r = new MetalPressRecipe(sOut, oInput, ApiUtils.createComparableItemStack(sMold, true), energy);
            if (inputSize > 0) {
                r.setInputSize(inputSize);
            }
            CraftTweakerAPI.apply((IAction)new Add(r));
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipeByMold(IItemStack mold) {
        CraftTweakerAPI.apply((IAction)new RemoveByMold(CraftTweakerHelper.toStack(mold)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        ArrayListMultimap<ComparableItemStack, MetalPressRecipe> removedRecipes;

        public void apply() {
            this.removedRecipes = ArrayListMultimap.create(MetalPressRecipe.recipeList);
            MetalPressRecipe.recipeList.clear();
        }

        public String describe() {
            return "Removing all Metal Press Recipes";
        }
    }

    private static class RemoveByMold
    implements IAction {
        private final ComparableItemStack mold;
        List<MetalPressRecipe> removedRecipes;

        public RemoveByMold(ItemStack mold) {
            this.mold = ApiUtils.createComparableItemStack(mold, true);
        }

        public void apply() {
            this.removedRecipes = new ArrayList<MetalPressRecipe>(MetalPressRecipe.recipeList.get((Object)this.mold));
            MetalPressRecipe.recipeList.removeAll((Object)this.mold);
        }

        public String describe() {
            return "Removing Metal Press Recipes for Mold: " + this.mold.stack.func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<MetalPressRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = MetalPressRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Metal Press Recipes for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final MetalPressRecipe recipe;

        public Add(MetalPressRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MetalPressRecipe.recipeList.put((Object)this.recipe.mold, (Object)this.recipe);
        }

        public String describe() {
            return "Adding Metal Press Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

