/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;

public class ModelData {
    @Nonnull
    public final ResourceLocation location;
    @Nonnull
    public final JsonObject data;
    @Nonnull
    public final ImmutableMap<String, String> textures;
    @Nullable
    private IModel model;

    public ModelData(@Nonnull ResourceLocation location, @Nonnull JsonObject data, @Nonnull ImmutableMap<String, String> textures) {
        this.location = location;
        this.data = data;
        this.textures = textures;
    }

    public void attemptToLoad(boolean throwError) {
        block2: {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)this.location);
                this.model = this.model.retexture(this.textures).process(ModelData.asMap(this.data, false));
            }
            catch (Exception e) {
                if (!throwError) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    public IModel getModel() {
        return this.model;
    }

    public static ModelData fromMap(ImmutableMap<String, String> customData, ImmutableSet<String> ownKeys, String base, ImmutableMap<String, String> texReplacements) {
        return ModelData.fromJson(ModelData.asJsonObject(customData), ownKeys, base, texReplacements);
    }

    public static ModelData fromJson(JsonObject customData, Collection<String> ownKeys, ImmutableMap<String, String> texReplacements) {
        return ModelData.fromJson(customData, ownKeys, "model", texReplacements);
    }

    public static ModelData fromJson(JsonObject customData, Collection<String> knownKeys, String modelKey, ImmutableMap<String, String> texReplacements) {
        String baseLocStr = customData.get(modelKey).getAsString();
        ResourceLocation baseLoc = new ResourceLocation(baseLocStr);
        JsonObject customBase = new JsonObject();
        if (customData.has("custom")) {
            customBase = customData.get("custom").getAsJsonObject();
        }
        for (Map.Entry e : customData.entrySet()) {
            if (knownKeys.contains(e.getKey()) || customBase.has((String)e.getKey())) continue;
            customBase.add((String)e.getKey(), (JsonElement)e.getValue());
        }
        if (customData.has("textures")) {
            JsonObject obj = customData.get("textures").getAsJsonObject();
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.putAll(texReplacements);
            b.putAll(ModelData.asMap(obj, true));
            texReplacements = b.build();
        }
        return new ModelData(baseLoc, customBase, texReplacements);
    }

    public static JsonObject asJsonObject(Map<String, String> map) {
        JsonObject ret = new JsonObject();
        JsonParser parser = new JsonParser();
        for (Map.Entry<String, String> e : map.entrySet()) {
            ret.add(e.getKey(), parser.parse(e.getValue()));
        }
        return ret;
    }

    public static ImmutableMap<String, String> asMap(JsonObject obj, boolean cleanStrings) {
        ImmutableMap.Builder ret = new ImmutableMap.Builder();
        for (Map.Entry entry : obj.entrySet()) {
            if (cleanStrings && ((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                ret.put(entry.getKey(), (Object)((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            ret.put(entry.getKey(), (Object)((JsonElement)entry.getValue()).toString());
        }
        return ret.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelData modelData = (ModelData)o;
        if (!this.location.equals((Object)modelData.location)) {
            return false;
        }
        if (!this.data.equals((Object)modelData.data)) {
            return false;
        }
        return this.textures.equals(modelData.textures);
    }

    public int hashCode() {
        int result = this.location.hashCode();
        result = 31 * result + this.data.hashCode();
        result = 31 * result + this.textures.hashCode();
        return result;
    }
}

