/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.vanilla;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.world.biome.BiomeCache;
import noisethreader.handlers.ForgeConfigHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BiomeCache.class})
public abstract class BiomeCacheMixin {
    @Unique
    private final ReentrantLock noisethreader$cacheLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"getEntry"})
    private BiomeCache.Block noisethreader_vanillaBiomeCache_getEntry(int x, int z, Operation<BiomeCache.Block> original) {
        if (!ForgeConfigHandler.server.multithreadBetterCavesNoise) {
            return (BiomeCache.Block)original.call(new Object[]{x, z});
        }
        this.noisethreader$cacheLock.lock();
        try {
            BiomeCache.Block block = (BiomeCache.Block)original.call(new Object[]{x, z});
            return block;
        }
        finally {
            this.noisethreader$cacheLock.unlock();
        }
    }

    @WrapMethod(method={"cleanupCache"})
    private void noisethreader_vanillaBiomeCache_cleanupCache(Operation<Void> original) {
        if (!ForgeConfigHandler.server.multithreadBetterCavesNoise) {
            original.call(new Object[0]);
            return;
        }
        this.noisethreader$cacheLock.lock();
        try {
            original.call(new Object[0]);
        }
        finally {
            this.noisethreader$cacheLock.unlock();
        }
    }
}

