/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.bettercaves;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.CavernCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeDictionary;
import noisethreader.util.bettercaves.ICavernCarver;
import noisethreader.util.bettercaves.NoiseColumnNew;
import noisethreader.util.bettercaves.NoiseCubeNew;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CavernCarverController.class})
public abstract class CavernCarverControllerMixin {
    @Shadow(remap=false)
    private List<CarverNoiseRange> noiseRanges;
    @Shadow(remap=false)
    private boolean isOverrideSurfaceDetectionEnabled;
    @Shadow(remap=false)
    private boolean isFloodedUndergroundEnabled;
    @Shadow(remap=false)
    private boolean isDebugViewEnabled;
    @Shadow(remap=false)
    private World world;
    @Shadow(remap=false)
    private static Predicate<Biome> isNotOcean;
    @Shadow(remap=false)
    private static Predicate<Biome> isOcean;
    @Shadow(remap=false)
    private FastNoise cavernRegionController;

    @Overwrite(remap=false)
    public void carveChunk(ChunkPrimer primer, int chunkX, int chunkZ, int[][] surfaceAltitudes, IBlockState[][] liquidBlocks) {
        if (this.noiseRanges.isEmpty()) {
            return;
        }
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                int startPosX = chunkX * 16 + startX;
                int startPosZ = chunkZ * 16 + startZ;
                int endPosX = chunkX * 16 + endX;
                int endPosZ = chunkZ * 16 + endZ;
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range.getCarver().getTopY());
                    }
                }
                NoiseCubeNew[] noiseCubes = new NoiseCubeNew[this.noiseRanges.size()];
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        BlockPos colPos = new BlockPos(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                        boolean flooded = false;
                        float smoothAmpFactor = 1.0f;
                        if (this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && (smoothAmpFactor = BetterCavesUtils.biomeDistanceFactor((World)this.world, (BlockPos)colPos, (int)2, (flooded = BiomeDictionary.hasType((Biome)this.world.func_180494_b(colPos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) ? isNotOcean : isOcean)) <= 0.0f) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        IBlockState liquidBlock = liquidBlocks[localX][localZ];
                        float cavernRegionNoise = this.cavernRegionController.GetNoise((float)colPos.func_177958_n(), (float)colPos.func_177952_p());
                        for (int rangeIndex = 0; rangeIndex < this.noiseRanges.size(); ++rangeIndex) {
                            int topY;
                            CarverNoiseRange range = this.noiseRanges.get(rangeIndex);
                            if (!range.contains(cavernRegionNoise)) continue;
                            CavernCarver carver = (CavernCarver)range.getCarver();
                            int bottomY = carver.getBottomY();
                            int n = topY = this.isDebugViewEnabled ? carver.getTopY() : Math.min(surfaceAltitude, carver.getTopY());
                            if (this.isOverrideSurfaceDetectionEnabled) {
                                topY = carver.getTopY();
                                maxHeight = carver.getTopY();
                            }
                            float smoothAmp = range.getSmoothAmp(cavernRegionNoise) * smoothAmpFactor;
                            if (noiseCubes[rangeIndex] == null) {
                                noiseCubes[rangeIndex] = ((ICavernCarver)carver).noisethreader$getNoiseGenNew().interpolateNoiseCube(startPosX, startPosZ, endPosX, endPosZ, bottomY, maxHeight);
                            }
                            NoiseColumnNew noiseColumn = noiseCubes[rangeIndex].getArray(offsetX)[offsetZ];
                            ((ICavernCarver)carver).noisethreader$carveColumnNew(primer, colPos, topY, smoothAmp, noiseColumn, liquidBlock, flooded);
                            continue block6;
                        }
                    }
                }
            }
        }
    }
}

