/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ReflectionStreams {
    public static Stream<Constructor> streamConstructors(@Nonnull Object from) {
        Objects.requireNonNull(from);
        return Arrays.stream(ReflectionStreams.classify(from).getConstructors());
    }

    public static Stream<Field> streamFields(@Nonnull Object from) {
        Objects.requireNonNull(from);
        return Arrays.stream(ReflectionStreams.classify(from).getDeclaredFields());
    }

    public static Stream<Field> streamAccessibleFields(@Nonnull Object from) {
        Objects.requireNonNull(from);
        Stream<Field> stream = ReflectionStreams.streamFields(from);
        if (from instanceof Class) {
            stream = stream.filter(ReflectionStreams::isStatic);
        }
        return stream;
    }

    public static Stream<Method> streamMethods(@Nonnull Object from) {
        Objects.requireNonNull(from);
        return Arrays.stream(ReflectionStreams.classify(from).getDeclaredMethods());
    }

    public static Stream<Method> streamAccessibleMethods(@Nonnull Object from) {
        Objects.requireNonNull(from);
        Stream<Method> stream = ReflectionStreams.streamMethods(from);
        if (from instanceof Class) {
            stream = stream.filter(ReflectionStreams::isStatic);
        }
        return stream;
    }

    public static <T extends AccessibleObject> Stream<T> streamMembers(@Nonnull Object from) {
        Objects.requireNonNull(from);
        return Stream.concat(ReflectionStreams.streamFields(from), ReflectionStreams.streamMethods(from));
    }

    public static <T extends AccessibleObject> Stream<T> streamAccessibleMembers(@Nonnull Object from) {
        Objects.requireNonNull(from);
        Stream<AccessibleObject> stream = ReflectionStreams.streamMembers(from);
        if (from instanceof Class) {
            stream = stream.filter(x$0 -> ReflectionStreams.isStatic((Member)x$0));
        }
        return stream;
    }

    public static Class<?> classify(@Nonnull Object obj) {
        Objects.requireNonNull(obj);
        return obj instanceof Class ? (Class<?>)obj : obj.getClass();
    }

    public static boolean isStatic(@Nonnull Member m) {
        Objects.requireNonNull(m);
        return Modifier.isStatic(m.getModifiers());
    }
}

