/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.entitytargeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityTargetingHandler {
    private static final EntityTargetingHandler INSTANCE = new EntityTargetingHandler();
    private Map<Class<? extends EntityCreature>, List<Class<? extends Entity>>> targetMap = new HashMap<Class<? extends EntityCreature>, List<Class<? extends Entity>>>();

    static EntityTargetingHandler getInstance() {
        return INSTANCE;
    }

    private EntityTargetingHandler() {
    }

    void registerEntityTargetingRule(Class<? extends Entity> target, Class<? extends EntityCreature> aggressor) {
        if (!this.targetMap.containsKey(aggressor)) {
            this.targetMap.put(aggressor, new ArrayList());
        }
        this.targetMap.get(aggressor).add(target);
    }

    @SubscribeEvent
    public void onZombieSpawn(LivingSpawnEvent event) {
        if (!(event.getEntity() instanceof EntityCreature)) {
            return;
        }
        EntityCreature entity = (EntityCreature)event.getEntity();
        for (Map.Entry<Class<? extends EntityCreature>, List<Class<? extends Entity>>> entry : this.targetMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
            for (Class<? extends Entity> entityClass : entry.getValue()) {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entity, entityClass, true));
            }
        }
    }
}

