/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.dualwield;

import com.infinityraider.infinitylib.modules.dualwield.ModelPlayerCustomized;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmSwingHandler {
    private static final ArmSwingHandler INSTANCE = new ArmSwingHandler();
    private final Map<UUID, Map<EnumHand, SwingProgress>> swingHandlers = new HashMap<UUID, Map<EnumHand, SwingProgress>>();

    public static ArmSwingHandler getInstance() {
        return INSTANCE;
    }

    private ArmSwingHandler() {
    }

    public void swingArm(EntityPlayer player, EnumHand hand) {
        this.getSwingProgressForPlayerAndHand(player, hand).swingArm();
    }

    public float getSwingProgress(EntityPlayer player, EnumHand hand, float partialTick) {
        return this.getSwingProgressForPlayerAndHand(player, hand).getSwingProgress(partialTick);
    }

    public SwingProgress getSwingProgressForPlayerAndHand(EntityPlayer player, EnumHand hand) {
        if (!this.swingHandlers.containsKey(player.func_110124_au())) {
            SwingProgress progress = new SwingProgress(player, hand);
            HashMap<EnumHand, SwingProgress> subMap = new HashMap<EnumHand, SwingProgress>();
            subMap.put(hand, progress);
            this.swingHandlers.put(player.func_110124_au(), subMap);
            return progress;
        }
        Map<EnumHand, SwingProgress> subMap = this.swingHandlers.get(player.func_110124_au());
        if (!subMap.containsKey(hand)) {
            SwingProgress progress = new SwingProgress(player, hand);
            subMap.put(hand, progress);
            return progress;
        }
        return subMap.get(hand);
    }

    @SubscribeEvent
    public void onUpdateTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map<EnumHand, SwingProgress> subMap : this.swingHandlers.values()) {
                subMap.values().forEach(rec$ -> ((SwingProgress)rec$).onUpdate());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRenderCall(RenderPlayerEvent.Pre event) {
        ModelPlayer model = event.getRenderer().func_177087_b();
        if (model instanceof ModelPlayerCustomized) {
            float left = this.getSwingProgress(event.getEntityPlayer(), EnumHand.OFF_HAND, event.getPartialRenderTick());
            float right = this.getSwingProgress(event.getEntityPlayer(), EnumHand.MAIN_HAND, event.getPartialRenderTick());
            ((ModelPlayerCustomized)model).setSwingProgress(left, right);
        }
    }

    private static class SwingProgress {
        private final EntityPlayer player;
        private final EnumHand hand;
        private float swingProgress;
        private float swingProgressPrev;
        private int swingProgressInt;
        private boolean isSwingInProgress;

        private SwingProgress(EntityPlayer player, EnumHand hand) {
            this.player = player;
            this.hand = hand;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public EnumHand getHand() {
            return this.hand;
        }

        public float getSwingProgress(float partialTick) {
            float f = this.swingProgress - this.swingProgressPrev;
            if (f < 0.0f) {
                f += 1.0f;
            }
            return this.swingProgressPrev + f * partialTick;
        }

        private void onUpdate() {
            this.swingProgressPrev = this.swingProgress;
            this.updateArmSwingProgress();
        }

        private void updateArmSwingProgress() {
            int i = this.getArmSwingAnimationEnd();
            if (this.isSwingInProgress) {
                ++this.swingProgressInt;
                if (this.swingProgressInt >= i) {
                    this.swingProgressInt = 0;
                    this.isSwingInProgress = false;
                }
            } else {
                this.swingProgressInt = 0;
            }
            this.swingProgress = (float)this.swingProgressInt / (float)i;
        }

        public void swingArm() {
            ItemStack stack = this.getPlayer().func_184586_b(this.getHand());
            if (stack != null && stack.func_77973_b().onEntitySwing((EntityLivingBase)this.getPlayer(), stack)) {
                return;
            }
            if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
                this.swingProgressInt = -1;
            }
            this.isSwingInProgress = true;
        }

        private int getArmSwingAnimationEnd() {
            return this.getPlayer().func_70644_a(MobEffects.field_76422_e) ? 6 - (1 + this.getPlayer().func_70660_b(MobEffects.field_76422_e).func_76458_c()) : (this.getPlayer().func_70644_a(MobEffects.field_76419_f) ? 6 + (1 + this.getPlayer().func_70660_b(MobEffects.field_76419_f).func_76458_c()) * 2 : 6);
        }
    }
}

