/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.config.IModConfiguration;
import com.infinityraider.infinitylib.config.InfinityConfigurationHandler;
import com.infinityraider.infinitylib.network.INetworkWrapper;
import com.infinityraider.infinitylib.network.NetworkWrapper;
import com.infinityraider.infinitylib.proxy.base.IProxyBase;
import com.infinityraider.infinitylib.utility.InfinityLogger;
import com.infinityraider.infinitylib.utility.ModEventHandlerHack;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class InfinityMod {
    private final InfinityLogger logger = new InfinityLogger(this);
    private final INetworkWrapper networkWrapper = new NetworkWrapper(this);
    private final InfinityConfigurationHandler configurationHandler = new InfinityConfigurationHandler(this);

    public InfinityMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModEventHandlerHack.doHack(this);
        this.initializeAPI();
    }

    public final InfinityLogger getLogger() {
        return this.logger;
    }

    public final INetworkWrapper getNetworkWrapper() {
        return this.networkWrapper;
    }

    public final InfinityConfigurationHandler getConfigurationHandler() {
        return this.configurationHandler;
    }

    public abstract IProxyBase proxy();

    public abstract String getModId();

    public abstract IModConfiguration getConfiguration();

    public Object getModBlockRegistry() {
        return null;
    }

    public Object getModItemRegistry() {
        return null;
    }

    public Object getModBiomeRegistry() {
        return null;
    }

    public Object getModEnchantmentRegistry() {
        return null;
    }

    public Object getModEntityRegistry() {
        return null;
    }

    public Object getModPotionRegistry() {
        return null;
    }

    public Object getModPotionTypeRegistry() {
        return null;
    }

    public Object getModSoundRegistry() {
        return null;
    }

    public Object getModVillagerProfessionRegistry() {
        return null;
    }

    public void registerMessages(INetworkWrapper wrapper) {
    }

    public void initializeAPI() {
    }

    @SubscribeEvent
    public final void initRegistries(RegistryEvent.NewRegistry event) {
        InfinityLib.proxy.registerRegistries(this, event);
    }

    @SubscribeEvent
    public final void registerBlocks(RegistryEvent.Register<Block> event) {
        InfinityLib.proxy.registerBlocks(this, (IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerItems(RegistryEvent.Register<Item> event) {
        InfinityLib.proxy.registerItems(this, (IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        InfinityLib.proxy.registerRecipes(this, (IForgeRegistry<IRecipe>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerBiomes(RegistryEvent.Register<Biome> event) {
        InfinityLib.proxy.registerBiomes(this, (IForgeRegistry<Biome>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        InfinityLib.proxy.registerEnchantments(this, (IForgeRegistry<Enchantment>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        InfinityLib.proxy.registerEntities(this, (IForgeRegistry<EntityEntry>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerPotions(RegistryEvent.Register<Potion> event) {
        InfinityLib.proxy.registerPotions(this, (IForgeRegistry<Potion>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerPotionTypes(RegistryEvent.Register<PotionType> event) {
        InfinityLib.proxy.registerPotionTypes(this, (IForgeRegistry<PotionType>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        InfinityLib.proxy.registerSounds(this, (IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public final void registerVillagerProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        InfinityLib.proxy.registerVillagerProfessions(this, (IForgeRegistry<VillagerRegistry.VillagerProfession>)event.getRegistry());
    }

    @Mod.EventHandler
    public final void preInit(FMLPreInitializationEvent event) {
        this.getLogger().debug("Starting Pre-Initialization", new Object[0]);
        this.proxy().registerEventHandler(this);
        InfinityLib.proxy.initModConfiguration(this.getConfigurationHandler());
        this.proxy().preInitStart(event);
        this.proxy().activateRequiredModules();
        this.proxy().preInitEnd(event);
        this.getLogger().debug("Pre-Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void init(FMLInitializationEvent event) {
        this.getLogger().debug("Starting Initialization", new Object[0]);
        this.proxy().initStart(event);
        this.proxy().registerCapabilities();
        this.proxy().registerEventHandlers();
        this.registerMessages(this.getNetworkWrapper());
        this.proxy().initEnd(event);
        this.getLogger().debug("Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void postInit(FMLPostInitializationEvent event) {
        this.getLogger().debug("Starting Post-Initialization", new Object[0]);
        this.proxy().postInitStart(event);
        this.proxy().postInitEnd(event);
        this.getLogger().debug("Post-Initialization Complete", new Object[0]);
    }

    @Mod.EventHandler
    public final void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        this.proxy().onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public final void onServerStarting(FMLServerStartingEvent event) {
        this.proxy().onServerStarting(event);
    }

    @Mod.EventHandler
    public final void onServerStarted(FMLServerStartedEvent event) {
        this.proxy().onServerStarted(event);
    }

    @Mod.EventHandler
    public final void onServerStopping(FMLServerStoppingEvent event) {
        this.proxy().onServerStopping(event);
    }

    @Mod.EventHandler
    public final void onServerStopped(FMLServerStoppedEvent event) {
        this.proxy().onServerStopped(event);
    }

    public final Side getPhysicalSide() {
        return this.proxy().getPhysicalSide();
    }

    public final Side getEffectiveSide() {
        return this.proxy().getEffectiveSide();
    }

    public final MinecraftServer getMinecraftServer() {
        return this.proxy().getMinecraftServer();
    }

    public final EntityPlayer getClientPlayer() {
        return this.proxy().getClientPlayer();
    }

    public final World getClientWorld() {
        return this.proxy().getClientWorld();
    }

    public final World getWorldByDimensionId(int dimension) {
        return this.proxy().getWorldByDimensionId(dimension);
    }

    public final Entity getEntityById(int dimension, int id) {
        return this.proxy().getEntityById(dimension, id);
    }

    public final Entity getEntityById(World world, int id) {
        return this.proxy().getEntityById(world, id);
    }

    public final void queueTask(Runnable task) {
        this.proxy().queueTask(task);
    }
}

