/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TRandomUpdateTickPart;
import codechicken.multipart.TickScheduler;
import codechicken.multipart.minecraft.Content;
import codechicken.multipart.minecraft.McMultipartSPH;
import codechicken.multipart.minecraft.TorchPart;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class RedstoneTorchPart
extends TorchPart
implements IFaceRedstonePart,
TRandomUpdateTickPart {
    public static BlockRedstoneTorch torchActive = (BlockRedstoneTorch)Blocks.field_150429_aA;
    public static BlockRedstoneTorch torchIdle = (BlockRedstoneTorch)Blocks.field_150437_az;
    private BurnoutEntry burnout;

    public RedstoneTorchPart() {
        this.state = torchActive.func_176223_P();
    }

    public RedstoneTorchPart(IBlockState state) {
        super(state);
    }

    @Override
    public ResourceLocation getType() {
        return Content.REDTORCH;
    }

    @Override
    public byte getMeta() {
        int m = this.getBlock().func_176201_c(this.state);
        if (this.active()) {
            m |= 0x80;
        }
        return (byte)m;
    }

    @Override
    public void setMeta(byte meta) {
        this.state = ((meta & 0x80) != 0 ? torchActive : torchIdle).func_176203_a(meta & 0x7F);
    }

    @Override
    public Block getBlock() {
        return this.active() ? torchActive : torchIdle;
    }

    public boolean active() {
        return this.state.func_177230_c() == torchActive;
    }

    @Override
    public void randomDisplayTick(Random random) {
        if (!this.active()) {
            return;
        }
        super.randomDisplayTick(random);
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((Block)torchActive);
    }

    @Override
    public void onNeighborChanged() {
        if (!this.world().field_72995_K && !this.dropIfCantStay() && this.isBeingPowered() == this.active()) {
            this.scheduleTick(2);
        }
    }

    public boolean isBeingPowered() {
        return RedstoneInteractions.getPowerTo(this, this.getSideFromState()) > 0;
    }

    @Override
    public void scheduledTick() {
        if (!this.world().field_72995_K && this.isBeingPowered() == this.active()) {
            this.toggle();
        }
    }

    @Override
    public void randomUpdate() {
        this.scheduledTick();
    }

    @Override
    public void onWorldJoin() {
        TickScheduler.loadRandomTick(this);
    }

    private boolean burnedOut(boolean add) {
        BurnoutEntry b;
        long time = this.world().func_82737_E();
        while (this.burnout != null && this.burnout.timeout <= time) {
            this.burnout = this.burnout.next;
        }
        if (add) {
            BurnoutEntry e = new BurnoutEntry(this.world().func_82737_E() + 60L);
            if (this.burnout == null) {
                this.burnout = e;
            } else {
                b = this.burnout;
                while (b.next != null) {
                    b = b.next;
                }
                b.next = e;
            }
        }
        if (this.burnout == null) {
            return false;
        }
        int i = 0;
        b = this.burnout;
        while (b != null) {
            ++i;
            b = b.next;
        }
        return i >= 8;
    }

    private void toggle() {
        if (this.active()) {
            if (this.burnedOut(true)) {
                this.world().func_184133_a(null, this.pos(), SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.8f);
                McMultipartSPH.spawnBurnoutSmoke(this.world(), this.pos());
            }
        } else if (this.burnedOut(false)) {
            return;
        }
        this.state = this.active() ? torchIdle.func_176223_P().func_177226_a((IProperty)BlockRedstoneTorch.field_176596_a, this.state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a)) : torchActive.func_176223_P().func_177226_a((IProperty)BlockRedstoneTorch.field_176596_a, this.state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a));
        this.sendDescUpdate();
        this.tile().func_70296_d();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(1);
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
    }

    @Override
    public void onAdded() {
        if (this.active()) {
            this.tile().notifyNeighborChange(1);
        }
        this.onNeighborChanged();
    }

    @Override
    public int strongPowerLevel(int side) {
        return side == 1 && this.active() ? 15 : 0;
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() && side != this.getSideFromState() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSideFromState();
    }

    public class BurnoutEntry {
        long timeout;
        BurnoutEntry next;

        public BurnoutEntry(long l) {
            this.timeout = l;
        }
    }
}

