/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.RCFiles;
import ivorius.reccomplex.files.loading.FileSuffixFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FileHandler {
    public List<Path> tryFind(Path path, String name, String suffix) {
        Path filename = RCFiles.filenamePath(name, suffix);
        return RCFiles.listFilesRecursively(path, entry -> entry.getFileName().equals(filename), true);
    }

    public Set<String> tryFindIDs(Path path, String suffix) {
        return RCFiles.listFilesRecursively(path, new FileSuffixFilter(suffix), true).stream().map(Path::getFileName).map(Path::toString).map(FilenameUtils::removeExtension).collect(Collectors.toSet());
    }

    public Pair<Set<Path>, Set<Path>> tryDelete(Path path, String name, String suffix) {
        HashSet success = new HashSet();
        HashSet failure = new HashSet();
        this.tryFind(path, name, suffix).forEach(p -> {
            try {
                Files.delete(p);
                success.add(p);
            }
            catch (IOException e) {
                RecurrentComplex.logger.error("Error deleting resource: " + p, (Throwable)e);
                failure.add(p);
            }
        });
        return Pair.of(success, failure);
    }
}

