/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.util;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import thaumcraft.common.lib.utils.BlockUtils;

@Mixin(value={BlockUtils.class})
public class BlockUtilsMixin {
    @Redirect(method={"breakFurthestBlock"}, at=@At(value="INVOKE", target="harvestBlockSkipCheck(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;)Z", remap=false), remap=false)
    private static boolean redirectHarvestBlock(World world, EntityPlayer player, BlockPos pos) {
        return BlockUtils.harvestBlock((World)world, (EntityPlayer)player, (BlockPos)pos, (boolean)false, (boolean)false, (int)0, (boolean)false);
    }

    @WrapOperation(method={"harvestBlock(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;ZZIZ)Z"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onBlockBreakEvent(Lnet/minecraft/world/World;Lnet/minecraft/world/GameType;Lnet/minecraft/entity/player/EntityPlayerMP;Lnet/minecraft/util/math/BlockPos;)I", remap=false)}, remap=false)
    private static int wrapBlockBreakEvent(World world, GameType type, EntityPlayerMP player, BlockPos pos, Operation<Integer> original) {
        if (player instanceof FakePlayer) {
            boolean preCancelEvent = false;
            ItemStack stack = player.func_184614_ca();
            if (type.func_77145_d() && !stack.func_190926_b() && !stack.func_77973_b().canDestroyBlockInCreative(world, pos, stack, (EntityPlayer)player)) {
                preCancelEvent = true;
            }
            if (type.func_82752_c() && (type == GameType.SPECTATOR || !player.func_175142_cm() && (stack.func_190926_b() || !stack.func_179544_c(world.func_180495_p(pos).func_177230_c())))) {
                preCancelEvent = true;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), (EntityPlayer)player);
            event.setCanceled(preCancelEvent);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isCanceled() ? -1 : event.getExpToDrop();
        }
        return (Integer)original.call(new Object[]{world, type, player, pos});
    }
}

