/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.network;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.common.lib.network.playerdata.PacketSyncProgressToServer;
import thaumcraft.common.lib.research.ResearchManager;

@Mixin(value={PacketSyncProgressToServer.class})
public class PacketSyncProgressToServerMixin {
    @WrapOperation(method={"fromBytes"}, at={@At(value="FIELD", opcode=181, target="Lthaumcraft/common/lib/network/playerdata/PacketSyncProgressToServer;checks:Z", remap=false)}, remap=false)
    private void forceChecksOn(PacketSyncProgressToServer packet, boolean value, Operation<Void> original) {
        original.call(new Object[]{packet, true});
    }

    @WrapOperation(method={"checkRequisites"}, at={@At(value="INVOKE", target="Lthaumcraft/api/research/ResearchEntry;getStages()[Lthaumcraft/api/research/ResearchStage;", ordinal=0, remap=false)}, remap=false)
    private ResearchStage[] wrapUnsafeDeref(@Nullable ResearchEntry entry, Operation<ResearchStage[]> original) {
        return entry != null ? (ResearchStage[])original.call(new Object[]{entry}) : null;
    }

    @ModifyReturnValue(method={"checkRequisites"}, at={@At(value="RETURN")}, remap=false)
    private boolean blockNullResearch(boolean original, @Local(ordinal=0) ResearchEntry entry) {
        return entry != null ? original : false;
    }

    @ModifyExpressionValue(method={"checkRequisites"}, at={@At(value="INVOKE", target="Lthaumcraft/api/capabilities/IPlayerKnowledge;getResearchStage(Ljava/lang/String;)I", remap=false)}, remap=false)
    private int checkProgressSyncStage(int originalStage, EntityPlayer player, String key, @Local(ordinal=0) ResearchEntry entry) {
        boolean noParentPass;
        int logicStage = originalStage;
        boolean hasParents = entry.getParents() != null && entry.getParents().length > 0;
        boolean hidden = entry.getMeta() != null && Arrays.stream(entry.getMeta()).anyMatch(e -> e == ResearchEntry.EnumResearchMeta.HIDDEN);
        ResearchCategory category = ResearchCategories.getResearchCategory((String)entry.getCategory());
        boolean bl = noParentPass = !hidden && category != null && (category.researchKey == null || ThaumcraftCapabilities.knowsResearchStrict((EntityPlayer)player, (String[])new String[]{category.researchKey}));
        if (logicStage < 1 && (hasParents || noParentPass) && ResearchManager.doesPlayerHaveRequisites((EntityPlayer)player, (String)entry.getKey())) {
            logicStage = Integer.MAX_VALUE;
        }
        return logicStage;
    }
}

