/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.event;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.world.aura.AuraThread;
import thecodex6824.thaumcraftfix.api.aura.CapabilityAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.common.aura.GenericAuraThread;

@Mixin(value={ServerEvents.class})
public class ServerEventsMixin {
    private static ThreadLocal<Field> playerField = new ThreadLocal();
    private static ThreadLocal<Field> posField = new ThreadLocal();
    private static ThreadLocal<Field> targetField = new ThreadLocal();

    @Redirect(method={"worldTick(Lnet/minecraftforge/fml/common/gameevent/TickEvent$WorldTickEvent;)V"}, at=@At(value="NEW", target="(I)Lthaumcraft/common/world/aura/AuraThread;", remap=false), remap=false)
    private static AuraThread redirectCreateAuraThread(int dim, TickEvent.WorldTickEvent event) {
        return new GenericAuraThread(dim, (IAuraProcessor)event.world.getCapability(CapabilityAuraProcessor.AURA_PROCESSOR, null));
    }

    private static EntityPlayer getSwapperPlayer(ServerEvents.VirtualSwapper vs) {
        try {
            if (playerField.get() == null) {
                Field field = ServerEvents.VirtualSwapper.class.getDeclaredField("player");
                field.setAccessible(true);
                playerField.set(field);
            }
            return (EntityPlayer)playerField.get().get(vs);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static BlockPos getSwapperPos(ServerEvents.VirtualSwapper vs) {
        try {
            if (posField.get() == null) {
                Field field = ServerEvents.VirtualSwapper.class.getDeclaredField("pos");
                field.setAccessible(true);
                posField.set(field);
            }
            return (BlockPos)posField.get().get(vs);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static ItemStack getSwapperTarget(ServerEvents.VirtualSwapper vs) {
        try {
            if (targetField.get() == null) {
                Field field = ServerEvents.VirtualSwapper.class.getDeclaredField("target");
                field.setAccessible(true);
                targetField.set(field);
            }
            return (ItemStack)targetField.get().get(vs);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Redirect(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/event/ForgeEventFactory;onPlayerBlockPlace(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraftforge/common/util/BlockSnapshot;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/util/EnumHand;)Lnet/minecraftforge/event/world/BlockEvent$PlaceEvent;", remap=false), remap=false)
    private static BlockEvent.PlaceEvent redirectPlaceEvent(@Nonnull EntityPlayer player, @Nonnull BlockSnapshot snapshot, @Nonnull EnumFacing direction, @Nonnull EnumHand hand, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        snapshotRef.set((Object)snapshot);
        return new BlockEvent.PlaceEvent(snapshot, snapshot.getReplacedBlock(), player, hand);
    }

    @ModifyConstant(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, constant={@Constant(ordinal=0, expandZeroConditions={Constant.Condition.GREATER_THAN_OR_EQUAL_TO_ZERO})}, remap=false)
    private static int wrapSlotCheck(int original, World world, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef, @Local(ordinal=0) ServerEvents.VirtualSwapper vs, @Local(ordinal=1) int slot) {
        boolean placeAllowed = slot >= original;
        BlockSnapshot snapshot = (BlockSnapshot)snapshotRef.get();
        if (placeAllowed && snapshot != null) {
            Block block;
            IBlockState toPlace = null;
            ItemStack target = ServerEventsMixin.getSwapperTarget(vs);
            if (target != null && !target.func_190926_b() && (block = Block.func_149634_a((Item)target.func_77973_b())) != null && block != Blocks.field_150350_a) {
                toPlace = block.func_176203_a(target.func_77952_i());
            }
            BlockPos pos = ServerEventsMixin.getSwapperPos(vs);
            if (toPlace != null) {
                world.func_175656_a(pos, toPlace);
                EntityPlayer player = ServerEventsMixin.getSwapperPlayer(vs);
                boolean bl = placeAllowed = !ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)snapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled();
                if (!placeAllowed) {
                    world.func_175698_g(pos);
                    if (!player.func_184812_l_()) {
                        snapshot.getReplacedBlock().func_177230_c().func_176226_b(snapshot.getWorld(), snapshot.getPos(), snapshot.getReplacedBlock(), 0);
                    }
                }
            } else {
                world.func_175698_g(pos);
            }
        }
        return placeAllowed ? original : Integer.MAX_VALUE;
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z", remap=true)}, remap=false)
    private static boolean wrapOriginalSetBlockstate(World world, BlockPos pos, IBlockState state, int flags, Operation<Boolean> original, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        boolean result = true;
        if (snapshotRef.get() == null) {
            result = (Boolean)original.call(new Object[]{world, pos, state, flags});
        }
        return result;
    }

    @WrapOperation(method={"tickBlockSwap(Lnet/minecraft/world/World;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z", remap=true)}, remap=false)
    private static boolean wrapOriginalSetBlockToAir(World world, BlockPos pos, Operation<Boolean> original, @Share(value="snapshot") LocalRef<BlockSnapshot> snapshotRef) {
        boolean result = true;
        if (snapshotRef.get() == null) {
            result = (Boolean)original.call(new Object[]{world, pos});
        }
        return result;
    }
}

